/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox;

import io.namastack.outbox.OutboxRecordStatus;
import io.namastack.outbox.partition.PartitionHasher;
import java.time.Clock;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 <2\u00020\u0001:\u0002;<B[\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020)H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020)H\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u0002022\u0006\u00105\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b6J\u001d\u00107\u001a\u00020)2\u0006\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b:R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0018\"\u0004\b!\u0010\"R$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010%R$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0018\"\u0004\b'\u0010\"\u00a8\u0006="}, d2={"Lio/namastack/outbox/OutboxRecord;", "", "id", "", "aggregateId", "eventType", "payload", "createdAt", "Ljava/time/OffsetDateTime;", "partition", "", "status", "Lio/namastack/outbox/OutboxRecordStatus;", "completedAt", "retryCount", "nextRetryAt", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/OffsetDateTime;ILio/namastack/outbox/OutboxRecordStatus;Ljava/time/OffsetDateTime;ILjava/time/OffsetDateTime;)V", "getId", "()Ljava/lang/String;", "getAggregateId", "getEventType", "getPayload", "getCreatedAt", "()Ljava/time/OffsetDateTime;", "getPartition", "()I", "value", "getStatus", "()Lio/namastack/outbox/OutboxRecordStatus;", "setStatus$namastack_outbox_core", "(Lio/namastack/outbox/OutboxRecordStatus;)V", "getCompletedAt", "setCompletedAt$namastack_outbox_core", "(Ljava/time/OffsetDateTime;)V", "getRetryCount", "setRetryCount$namastack_outbox_core", "(I)V", "getNextRetryAt", "setNextRetryAt$namastack_outbox_core", "markCompleted", "", "clock", "Ljava/time/Clock;", "markCompleted$namastack_outbox_core", "markFailed", "markFailed$namastack_outbox_core", "incrementRetryCount", "incrementRetryCount$namastack_outbox_core", "canBeRetried", "", "canBeRetried$namastack_outbox_core", "retriesExhausted", "maxRetries", "retriesExhausted$namastack_outbox_core", "scheduleNextRetry", "delay", "Ljava/time/Duration;", "scheduleNextRetry$namastack_outbox_core", "Builder", "Companion", "namastack-outbox-core"})
public final class OutboxRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String aggregateId;
    @NotNull
    private final String eventType;
    @NotNull
    private final String payload;
    @NotNull
    private final OffsetDateTime createdAt;
    private final int partition;
    @NotNull
    private OutboxRecordStatus status;
    @Nullable
    private OffsetDateTime completedAt;
    private int retryCount;
    @NotNull
    private OffsetDateTime nextRetryAt;

    public OutboxRecord(@NotNull String id, @NotNull String aggregateId, @NotNull String eventType, @NotNull String payload, @NotNull OffsetDateTime createdAt, int partition, @NotNull OutboxRecordStatus status, @Nullable OffsetDateTime completedAt, int retryCount, @NotNull OffsetDateTime nextRetryAt) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)nextRetryAt, (String)"nextRetryAt");
        this.id = id;
        this.aggregateId = aggregateId;
        this.eventType = eventType;
        this.payload = payload;
        this.createdAt = createdAt;
        this.partition = partition;
        this.status = status;
        this.completedAt = completedAt;
        this.retryCount = retryCount;
        this.nextRetryAt = nextRetryAt;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getAggregateId() {
        return this.aggregateId;
    }

    @NotNull
    public final String getEventType() {
        return this.eventType;
    }

    @NotNull
    public final String getPayload() {
        return this.payload;
    }

    @NotNull
    public final OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public final int getPartition() {
        return this.partition;
    }

    @NotNull
    public final OutboxRecordStatus getStatus() {
        return this.status;
    }

    public final void setStatus$namastack_outbox_core(@NotNull OutboxRecordStatus outboxRecordStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)outboxRecordStatus), (String)"<set-?>");
        this.status = outboxRecordStatus;
    }

    @Nullable
    public final OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public final void setCompletedAt$namastack_outbox_core(@Nullable OffsetDateTime offsetDateTime) {
        this.completedAt = offsetDateTime;
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final void setRetryCount$namastack_outbox_core(int n) {
        this.retryCount = n;
    }

    @NotNull
    public final OffsetDateTime getNextRetryAt() {
        return this.nextRetryAt;
    }

    public final void setNextRetryAt$namastack_outbox_core(@NotNull OffsetDateTime offsetDateTime) {
        Intrinsics.checkNotNullParameter((Object)offsetDateTime, (String)"<set-?>");
        this.nextRetryAt = offsetDateTime;
    }

    public final void markCompleted$namastack_outbox_core(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        if (this.status != OutboxRecordStatus.COMPLETED) {
            this.completedAt = OffsetDateTime.now(clock);
            this.status = OutboxRecordStatus.COMPLETED;
        }
    }

    public final void markFailed$namastack_outbox_core() {
        if (this.status != OutboxRecordStatus.FAILED) {
            this.status = OutboxRecordStatus.FAILED;
        }
    }

    public final void incrementRetryCount$namastack_outbox_core() {
        int n = this.retryCount;
        this.retryCount = n + 1;
    }

    public final boolean canBeRetried$namastack_outbox_core(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return this.nextRetryAt.isBefore(OffsetDateTime.now(clock)) && this.status == OutboxRecordStatus.NEW;
    }

    public final boolean retriesExhausted$namastack_outbox_core(int maxRetries) {
        return this.retryCount >= maxRetries;
    }

    public final void scheduleNextRetry$namastack_outbox_core(@NotNull Duration delay, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        OffsetDateTime offsetDateTime = OffsetDateTime.now(clock).plus(delay);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"plus(...)");
        this.nextRetryAt = offsetDateTime;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/namastack/outbox/OutboxRecord$Builder;", "", "<init>", "()V", "aggregateId", "", "eventType", "payload", "build", "Lio/namastack/outbox/OutboxRecord;", "clock", "Ljava/time/Clock;", "namastack-outbox-core"})
    @SourceDebugExtension(value={"SMAP\nOutboxRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutboxRecord.kt\nio/namastack/outbox/OutboxRecord$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1#2:228\n*E\n"})
    public static final class Builder {
        private String aggregateId;
        private String eventType;
        private String payload;

        @NotNull
        public final Builder aggregateId(@NotNull String aggregateId) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            Builder $this$aggregateId_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$aggregateId_u24lambda_u240.aggregateId = aggregateId;
            return builder;
        }

        @NotNull
        public final Builder eventType(@NotNull String eventType) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
            Builder $this$eventType_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$eventType_u24lambda_u240.eventType = eventType;
            return builder;
        }

        @NotNull
        public final Builder payload(@NotNull String payload) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Builder $this$payload_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$payload_u24lambda_u240.payload = payload;
            return builder;
        }

        @NotNull
        public final OutboxRecord build(@NotNull Clock clock) {
            String string;
            String string2;
            String string3;
            String string4;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            OffsetDateTime now = OffsetDateTime.now(clock);
            String string5 = this.aggregateId;
            if (string5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateId");
                string5 = null;
            }
            int partition = PartitionHasher.INSTANCE.getPartitionForAggregate(string5);
            String string6 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            String string7 = string6;
            OutboxRecordStatus outboxRecordStatus = OutboxRecordStatus.NEW;
            String string8 = this.aggregateId;
            if (string8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateId");
                string8 = string4 = null;
            }
            if ((string3 = this.eventType) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"eventType");
                string3 = string2 = null;
            }
            if ((string = this.payload) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payload");
                string = null;
            }
            String string9 = string;
            Intrinsics.checkNotNull((Object)now);
            OffsetDateTime offsetDateTime = now;
            OffsetDateTime offsetDateTime2 = now;
            return new OutboxRecord(string7, string4, string2, string9, offsetDateTime, partition, outboxRecordStatus, null, 0, offsetDateTime2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f\u00a8\u0006\u0014"}, d2={"Lio/namastack/outbox/OutboxRecord$Companion;", "", "<init>", "()V", "restore", "Lio/namastack/outbox/OutboxRecord;", "id", "", "aggregateId", "eventType", "payload", "createdAt", "Ljava/time/OffsetDateTime;", "status", "Lio/namastack/outbox/OutboxRecordStatus;", "completedAt", "retryCount", "", "partition", "nextRetryAt", "namastack-outbox-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OutboxRecord restore(@NotNull String id, @NotNull String aggregateId, @NotNull String eventType, @NotNull String payload, @NotNull OffsetDateTime createdAt, @NotNull OutboxRecordStatus status, @Nullable OffsetDateTime completedAt, int retryCount, int partition, @NotNull OffsetDateTime nextRetryAt) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)nextRetryAt, (String)"nextRetryAt");
            return new OutboxRecord(id, aggregateId, eventType, payload, createdAt, partition, status, completedAt, retryCount, nextRetryAt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

