/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox;

import io.namastack.outbox.OutboxInstance;
import io.namastack.outbox.OutboxInstanceRepository;
import io.namastack.outbox.OutboxInstanceStatus;
import io.namastack.outbox.OutboxProperties;
import jakarta.annotation.PostConstruct;
import java.net.InetAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u000eJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020!H\u0007J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0018H\u0002J\b\u0010'\u001a\u00020!H\u0002J\u0006\u0010(\u001a\u00020!J\b\u0010)\u001a\u00020!H\u0007J\u0010\u0010*\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0018H\u0002J\b\u0010+\u001a\u00020\u000eH\u0002J\b\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \f*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/namastack/outbox/OutboxInstanceRegistry;", "", "instanceRepository", "Lio/namastack/outbox/OutboxInstanceRepository;", "properties", "Lio/namastack/outbox/OutboxProperties;", "clock", "Ljava/time/Clock;", "<init>", "(Lio/namastack/outbox/OutboxInstanceRepository;Lio/namastack/outbox/OutboxProperties;Ljava/time/Clock;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "currentInstanceId", "", "knownInstances", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/time/OffsetDateTime;", "staleInstanceTimeout", "Ljava/time/Duration;", "gracefulShutdownTimeout", "getCurrentInstanceId", "getActiveInstances", "", "Lio/namastack/outbox/OutboxInstance;", "getActiveInstanceIds", "", "isInstanceActive", "", "instanceId", "getActiveInstanceCount", "", "registerInstance", "", "performHeartbeatAndCleanup", "sendHeartbeat", "cleanupStaleInstances", "handleStaleInstance", "instance", "reregisterInstance", "gracefulShutdown", "detectNewInstances", "handleNewInstance", "generateInstanceId", "getApplicationPort", "", "namastack-outbox-core"})
@SourceDebugExtension(value={"SMAP\nOutboxInstanceRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutboxInstanceRegistry.kt\nio/namastack/outbox/OutboxInstanceRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1563#2:256\n1634#2,3:257\n1869#2,2:260\n1563#2:262\n1634#2,3:263\n1869#2:266\n1870#2:268\n1869#2,2:269\n1#3:267\n*S KotlinDebug\n*F\n+ 1 OutboxInstanceRegistry.kt\nio/namastack/outbox/OutboxInstanceRegistry\n*L\n53#1:256\n53#1:257,3\n137#1:260,2\n205#1:262\n205#1:263,3\n210#1:266\n210#1:268\n218#1:269,2\n*E\n"})
public final class OutboxInstanceRegistry {
    @NotNull
    private final OutboxInstanceRepository instanceRepository;
    @NotNull
    private final OutboxProperties properties;
    @NotNull
    private final Clock clock;
    private final Logger log;
    @NotNull
    private final String currentInstanceId;
    @NotNull
    private final ConcurrentHashMap<String, OffsetDateTime> knownInstances;
    private final Duration staleInstanceTimeout;
    private final Duration gracefulShutdownTimeout;

    public OutboxInstanceRegistry(@NotNull OutboxInstanceRepository instanceRepository, @NotNull OutboxProperties properties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)instanceRepository, (String)"instanceRepository");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.instanceRepository = instanceRepository;
        this.properties = properties;
        this.clock = clock;
        this.log = LoggerFactory.getLogger(OutboxInstanceRegistry.class);
        this.currentInstanceId = this.generateInstanceId();
        this.knownInstances = new ConcurrentHashMap();
        this.staleInstanceTimeout = Duration.ofSeconds(this.properties.getInstance().getStaleInstanceTimeoutSeconds());
        this.gracefulShutdownTimeout = Duration.ofSeconds(this.properties.getInstance().getGracefulShutdownTimeoutSeconds());
    }

    @NotNull
    public final String getCurrentInstanceId() {
        return this.currentInstanceId;
    }

    @NotNull
    public final List<OutboxInstance> getActiveInstances() {
        return this.instanceRepository.findActiveInstances();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getActiveInstanceIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getActiveInstances();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutboxInstance outboxInstance = (OutboxInstance)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInstanceId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean isInstanceActive(@NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        OutboxInstance outboxInstance = this.instanceRepository.findById(instanceId);
        return (outboxInstance != null ? outboxInstance.getStatus() : null) == OutboxInstanceStatus.ACTIVE;
    }

    public final long getActiveInstanceCount() {
        return this.instanceRepository.countByStatus(OutboxInstanceStatus.ACTIVE);
    }

    @PostConstruct
    public final void registerInstance() {
        try {
            OffsetDateTime now = OffsetDateTime.now(this.clock);
            String hostname = InetAddress.getLocalHost().getHostName();
            int port = this.getApplicationPort();
            Intrinsics.checkNotNull((Object)hostname);
            OutboxInstance instance = OutboxInstance.Companion.create(this.currentInstanceId, hostname, port, OutboxInstanceStatus.ACTIVE, this.clock);
            this.instanceRepository.save(instance);
            ((Map)this.knownInstances).put(this.currentInstanceId, now);
            Object[] objectArray = new Object[]{this.currentInstanceId, hostname, port};
            this.log.info("\ud83d\udcdd Registered outbox instance: {} on {}:{}", objectArray);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> OutboxInstanceRegistry.registerInstance$lambda$0(this)));
        }
        catch (Exception ex) {
            this.log.error("Failed to register instance {}", (Object)this.currentInstanceId, (Object)ex);
            throw ex;
        }
    }

    @Scheduled(fixedRateString="${outbox.instance.heartbeat-interval-seconds:5}000")
    public final void performHeartbeatAndCleanup() {
        try {
            this.sendHeartbeat();
            this.cleanupStaleInstances();
        }
        catch (Exception ex) {
            this.log.error("Error during heartbeat and cleanup", (Throwable)ex);
        }
    }

    private final void sendHeartbeat() {
        OffsetDateTime now = OffsetDateTime.now(this.clock);
        Intrinsics.checkNotNull((Object)now);
        boolean success = this.instanceRepository.updateHeartbeat(this.currentInstanceId, now);
        if (success) {
            ((Map)this.knownInstances).put(this.currentInstanceId, now);
            this.log.debug("\ud83d\udc93 Sent heartbeat for instance {}", (Object)this.currentInstanceId);
        } else {
            this.log.warn("\u26a0\ufe0f Failed to send heartbeat for instance {} - re-registering", (Object)this.currentInstanceId);
            this.reregisterInstance();
        }
    }

    private final void cleanupStaleInstances() {
        OffsetDateTime cutoffTime = OffsetDateTime.now(this.clock).minus(this.staleInstanceTimeout);
        Intrinsics.checkNotNull((Object)cutoffTime);
        List<OutboxInstance> staleInstances = this.instanceRepository.findInstancesWithStaleHeartbeat(cutoffTime);
        Iterable $this$forEach$iv = staleInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OutboxInstance instance = (OutboxInstance)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)instance.getInstanceId(), (Object)this.currentInstanceId)) continue;
            this.handleStaleInstance(instance);
        }
    }

    private final void handleStaleInstance(OutboxInstance instance) {
        this.log.warn("\ud83d\udc80 Detected stale instance: {} (last heartbeat: {})", (Object)instance.getInstanceId(), (Object)instance.getLastHeartbeat());
        String string = instance.getInstanceId();
        OffsetDateTime offsetDateTime = OffsetDateTime.now(this.clock);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
        this.instanceRepository.updateStatus(string, OutboxInstanceStatus.DEAD, offsetDateTime);
        this.instanceRepository.deleteById(instance.getInstanceId());
        this.knownInstances.remove(instance.getInstanceId());
    }

    private final void reregisterInstance() {
        this.registerInstance();
    }

    public final void gracefulShutdown() {
        try {
            this.log.info("\ud83d\uded1 Initiating graceful shutdown for instance {}", (Object)this.currentInstanceId);
            OffsetDateTime offsetDateTime = OffsetDateTime.now(this.clock);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
            this.instanceRepository.updateStatus(this.currentInstanceId, OutboxInstanceStatus.SHUTTING_DOWN, offsetDateTime);
            Thread.sleep(this.gracefulShutdownTimeout.toMillis());
            this.instanceRepository.deleteById(this.currentInstanceId);
            this.knownInstances.remove(this.currentInstanceId);
            this.log.info("\u2705 Graceful shutdown completed for instance {}", (Object)this.currentInstanceId);
        }
        catch (Exception ex) {
            this.log.error("Error during graceful shutdown of instance {}", (Object)this.currentInstanceId, (Object)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedRateString="${outbox.instance.new-instance-detection-interval-seconds:10}000")
    public final void detectNewInstances() {
        try {
            void $this$mapTo$iv$iv;
            List<OutboxInstance> currentActive = this.getActiveInstances();
            Iterable $this$map$iv = currentActive;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                OutboxInstance outboxInstance = (OutboxInstance)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getInstanceId());
            }
            Set currentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Set set = this.knownInstances.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Set knownIds = CollectionsKt.toSet((Iterable)set);
            Set newInstanceIds = SetsKt.minus((Set)currentIds, (Iterable)knownIds);
            Iterable $this$forEach$iv = newInstanceIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutboxInstance instance;
                Object v1;
                block6: {
                    String instanceId = (String)element$iv;
                    boolean bl = false;
                    Iterable iterable2 = currentActive;
                    for (Object t : iterable2) {
                        OutboxInstance it = (OutboxInstance)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getInstanceId(), (Object)instanceId)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                if ((instance = (OutboxInstance)v1) == null) continue;
                this.handleNewInstance(instance);
            }
            $this$forEach$iv = currentActive;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutboxInstance instance = (OutboxInstance)element$iv;
                boolean bl = false;
                ((Map)this.knownInstances).put(instance.getInstanceId(), instance.getLastHeartbeat());
            }
        }
        catch (Exception ex) {
            this.log.error("Error detecting new instances", (Throwable)ex);
        }
    }

    private final void handleNewInstance(OutboxInstance instance) {
        if (!Intrinsics.areEqual((Object)instance.getInstanceId(), (Object)this.currentInstanceId)) {
            Object[] objectArray = new Object[]{instance.getInstanceId(), instance.getHostname(), instance.getPort()};
            this.log.info("\ud83c\udd95 Detected new instance: {} on {}:{}", objectArray);
        }
    }

    private final String generateInstanceId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int getApplicationPort() {
        int n;
        try {
            String string = System.getProperty("server.port");
            n = string != null ? Integer.parseInt(string) : 8080;
        }
        catch (Exception exception) {
            n = 8080;
        }
        return n;
    }

    private static final void registerInstance$lambda$0(OutboxInstanceRegistry this$0) {
        this$0.gracefulShutdown();
    }
}

