/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox;

import io.namastack.outbox.OutboxEvent;
import io.namastack.outbox.OutboxEventSerializer;
import io.namastack.outbox.OutboxProperties;
import io.namastack.outbox.OutboxRecord;
import io.namastack.outbox.OutboxRecordRepository;
import java.time.Clock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J!\u0010\u001d\u001a\u00020\u000f2\u0016\u0010\u001e\u001a\u0012\u0012\u0002\b\u0003  *\b\u0012\u0002\b\u0003\u0018\u00010\u001f0\u001fH\u0096\u0001J\u0019\u0010!\u001a\u00020\u000f2\u000e\u0010\"\u001a\n  *\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J\t\u0010#\u001a\u00020\u000fH\u0096\u0001J!\u0010$\u001a\u00020\u000f2\u0016\u0010\u001e\u001a\u0012\u0012\u0002\b\u0003  *\b\u0012\u0002\b\u0003\u0018\u00010\u001f0\u001fH\u0096\u0001J\u0019\u0010%\u001a\u00020\u000f2\u000e\u0010\"\u001a\n  *\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J5\u0010&\u001a\u00020\u000f2*\u0010'\u001a&\u0012\f\u0012\n  *\u0004\u0018\u00010\u001c0\u001c  *\u0012\u0012\f\u0012\n  *\u0004\u0018\u00010\u001c0\u001c\u0018\u00010(0(H\u0096\u0001JE\u0010)\u001a\u00020\u000f2:\u0010'\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003  *\b\u0012\u0002\b\u0003\u0018\u00010\u001f0\u001f  *\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003  *\b\u0012\u0002\b\u0003\u0018\u00010\u001f0\u001f\u0018\u00010(0(H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/namastack/outbox/OutboxEventMulticaster;", "Lorg/springframework/context/event/ApplicationEventMulticaster;", "delegateEventMulticaster", "Lorg/springframework/context/event/SimpleApplicationEventMulticaster;", "outboxRecordRepository", "Lio/namastack/outbox/OutboxRecordRepository;", "outboxEventSerializer", "Lio/namastack/outbox/OutboxEventSerializer;", "outboxProperties", "Lio/namastack/outbox/OutboxProperties;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/springframework/context/event/SimpleApplicationEventMulticaster;Lio/namastack/outbox/OutboxRecordRepository;Lio/namastack/outbox/OutboxEventSerializer;Lio/namastack/outbox/OutboxProperties;Ljava/time/Clock;)V", "multicastEvent", "", "event", "Lorg/springframework/context/ApplicationEvent;", "eventType", "Lorg/springframework/core/ResolvableType;", "extractEventPayload", "Lkotlin/Pair;", "", "Lio/namastack/outbox/OutboxEvent;", "saveOutboxRecord", "payload", "annotation", "resolveAggregateId", "", "addApplicationListener", "listener", "Lorg/springframework/context/ApplicationListener;", "kotlin.jvm.PlatformType", "addApplicationListenerBean", "listenerBeanName", "removeAllListeners", "removeApplicationListener", "removeApplicationListenerBean", "removeApplicationListenerBeans", "predicate", "Ljava/util/function/Predicate;", "removeApplicationListeners", "Companion", "namastack-outbox-core"})
@SourceDebugExtension(value={"SMAP\nOutboxEventMulticaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutboxEventMulticaster.kt\nio/namastack/outbox/OutboxEventMulticaster\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public final class OutboxEventMulticaster
implements ApplicationEventMulticaster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleApplicationEventMulticaster delegateEventMulticaster;
    @NotNull
    private final OutboxRecordRepository outboxRecordRepository;
    @NotNull
    private final OutboxEventSerializer outboxEventSerializer;
    @NotNull
    private final OutboxProperties outboxProperties;
    @NotNull
    private final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(OutboxEventMulticaster.class);
    @NotNull
    private static final SpelExpressionParser spelParser = new SpelExpressionParser();
    @NotNull
    private static final ConcurrentHashMap<String, Expression> expressionCache = new ConcurrentHashMap();

    public OutboxEventMulticaster(@NotNull SimpleApplicationEventMulticaster delegateEventMulticaster, @NotNull OutboxRecordRepository outboxRecordRepository, @NotNull OutboxEventSerializer outboxEventSerializer, @NotNull OutboxProperties outboxProperties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)delegateEventMulticaster, (String)"delegateEventMulticaster");
        Intrinsics.checkNotNullParameter((Object)outboxRecordRepository, (String)"outboxRecordRepository");
        Intrinsics.checkNotNullParameter((Object)outboxEventSerializer, (String)"outboxEventSerializer");
        Intrinsics.checkNotNullParameter((Object)outboxProperties, (String)"outboxProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.delegateEventMulticaster = delegateEventMulticaster;
        this.outboxRecordRepository = outboxRecordRepository;
        this.outboxEventSerializer = outboxEventSerializer;
        this.outboxProperties = outboxProperties;
        this.clock = clock;
    }

    public void multicastEvent(@NotNull ApplicationEvent event, @Nullable ResolvableType eventType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Pair<Object, OutboxEvent> pair = this.extractEventPayload(event);
        if (pair == null) {
            this.delegateEventMulticaster.multicastEvent(event, eventType);
            return;
        }
        Pair<Object, OutboxEvent> pair2 = pair;
        Object payload = pair2.component1();
        OutboxEvent annotation = (OutboxEvent)pair2.component2();
        log.debug("Saving @OutboxEvent to outbox: " + Reflection.getOrCreateKotlinClass(payload.getClass()).getSimpleName());
        this.saveOutboxRecord(payload, annotation);
        if (this.outboxProperties.getProcessing().getPublishAfterSave()) {
            log.debug("Publishing @OutboxEvent to listeners: " + Reflection.getOrCreateKotlinClass(payload.getClass()).getSimpleName());
            this.delegateEventMulticaster.multicastEvent(event, eventType);
        }
    }

    public void multicastEvent(@NotNull ApplicationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.multicastEvent(event, ResolvableType.forInstance((Object)event));
    }

    private final Pair<Object, OutboxEvent> extractEventPayload(ApplicationEvent event) {
        if (!(event instanceof PayloadApplicationEvent)) {
            return null;
        }
        OutboxEvent outboxEvent = ((PayloadApplicationEvent)event).getPayload().getClass().getAnnotation(OutboxEvent.class);
        if (outboxEvent == null) {
            return null;
        }
        OutboxEvent annotation = outboxEvent;
        return TuplesKt.to((Object)((PayloadApplicationEvent)event).getPayload(), (Object)annotation);
    }

    private final void saveOutboxRecord(Object payload, OutboxEvent annotation) {
        String string;
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("OutboxEvent requires an active transaction");
        }
        String aggregateId = this.resolveAggregateId(payload, annotation);
        String it = string = annotation.eventType();
        boolean bl = false;
        String string2 = ((CharSequence)it).length() > 0 ? string : null;
        if (string2 == null) {
            String string3 = Reflection.getOrCreateKotlinClass(payload.getClass()).getQualifiedName();
            string2 = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        String eventType = string2;
        this.outboxRecordRepository.save(new OutboxRecord.Builder().aggregateId(aggregateId).eventType(eventType).payload(this.outboxEventSerializer.serialize(payload)).build(this.clock));
    }

    private final String resolveAggregateId(Object payload, OutboxEvent annotation) {
        String string;
        try {
            String spelExpression = annotation.aggregateId();
            Expression expression = expressionCache.computeIfAbsent(spelExpression, arg_0 -> OutboxEventMulticaster.resolveAggregateId$lambda$1(OutboxEventMulticaster::resolveAggregateId$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"computeIfAbsent(...)");
            Expression expression2 = expression;
            StandardEvaluationContext context = new StandardEvaluationContext(payload);
            Object result = expression2.getValue((EvaluationContext)context);
            if (result == null) {
                throw new IllegalArgumentException("SpEL expression returned null: '" + spelExpression + "'");
            }
            if (!(result instanceof String)) {
                throw new IllegalArgumentException("SpEL expression must return String, but got " + Reflection.getOrCreateKotlinClass(result.getClass()).getSimpleName() + ": '" + spelExpression + "'");
            }
            string = (String)result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to resolve aggregateId from SpEL: '" + annotation.aggregateId() + "'. Valid examples: 'id', '#this.id', '#root.id'", e);
        }
        return string;
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        this.delegateEventMulticaster.addApplicationListener(listener);
    }

    public void addApplicationListenerBean(String listenerBeanName) {
        this.delegateEventMulticaster.addApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListener(ApplicationListener<?> listener) {
        this.delegateEventMulticaster.removeApplicationListener(listener);
    }

    public void removeApplicationListenerBean(String listenerBeanName) {
        this.delegateEventMulticaster.removeApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListeners(Predicate<ApplicationListener<?>> predicate) {
        this.delegateEventMulticaster.removeApplicationListeners(predicate);
    }

    public void removeApplicationListenerBeans(Predicate<String> predicate) {
        this.delegateEventMulticaster.removeApplicationListenerBeans(predicate);
    }

    public void removeAllListeners() {
        this.delegateEventMulticaster.removeAllListeners();
    }

    private static final Expression resolveAggregateId$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return spelParser.parseExpression(it);
    }

    private static final Expression resolveAggregateId$lambda$1(Function1 $tmp0, Object p0) {
        return (Expression)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/namastack/outbox/OutboxEventMulticaster$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "spelParser", "Lorg/springframework/expression/spel/standard/SpelExpressionParser;", "expressionCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/springframework/expression/Expression;", "namastack-outbox-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

