/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox;

import io.namastack.outbox.EnableOutbox;
import io.namastack.outbox.OutboxEventMulticaster;
import io.namastack.outbox.OutboxEventSerializer;
import io.namastack.outbox.OutboxInstanceRegistry;
import io.namastack.outbox.OutboxInstanceRepository;
import io.namastack.outbox.OutboxProcessingScheduler;
import io.namastack.outbox.OutboxProperties;
import io.namastack.outbox.OutboxRecordProcessor;
import io.namastack.outbox.OutboxRecordRepository;
import io.namastack.outbox.partition.PartitionCoordinator;
import io.namastack.outbox.retry.OutboxRetryPolicy;
import io.namastack.outbox.retry.OutboxRetryPolicyFactory;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@AutoConfiguration
@AutoConfigurationPackage
@ConditionalOnBean(annotation={EnableOutbox.class})
@EnableConfigurationProperties(value={OutboxProperties.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0017J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0017JJ\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006#"}, d2={"Lio/namastack/outbox/OutboxCoreAutoConfiguration;", "", "<init>", "()V", "clock", "Ljava/time/Clock;", "outboxTaskExecutor", "Lorg/springframework/scheduling/concurrent/ThreadPoolTaskExecutor;", "properties", "Lio/namastack/outbox/OutboxProperties;", "retryPolicy", "Lio/namastack/outbox/retry/OutboxRetryPolicy;", "outboxInstanceRegistry", "Lio/namastack/outbox/OutboxInstanceRegistry;", "instanceRepository", "Lio/namastack/outbox/OutboxInstanceRepository;", "partitionCoordinator", "Lio/namastack/outbox/partition/PartitionCoordinator;", "instanceRegistry", "partitionAwareOutboxProcessingScheduler", "Lio/namastack/outbox/OutboxProcessingScheduler;", "recordRepository", "Lio/namastack/outbox/OutboxRecordRepository;", "recordProcessor", "Lio/namastack/outbox/OutboxRecordProcessor;", "taskExecutor", "Lorg/springframework/core/task/TaskExecutor;", "outboxApplicationEventMulticaster", "Lio/namastack/outbox/OutboxEventMulticaster;", "beanFactory", "Lorg/springframework/beans/factory/BeanFactory;", "outboxRecordRepository", "outboxEventSerializer", "Lio/namastack/outbox/OutboxEventSerializer;", "outboxProperties", "namastack-outbox-core"})
public class OutboxCoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Clock clock() {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
        return clock;
    }

    @Bean
    @ConditionalOnMissingBean(name={"outboxTaskExecutor"})
    @NotNull
    public ThreadPoolTaskExecutor outboxTaskExecutor(@NotNull OutboxProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(properties.getProcessing().getExecutorCorePoolSize());
        executor.setMaxPoolSize(properties.getProcessing().getExecutorMaxPoolSize());
        executor.setThreadNamePrefix("outbox-proc-");
        executor.initialize();
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OutboxRetryPolicy retryPolicy(@NotNull OutboxProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return OutboxRetryPolicyFactory.INSTANCE.create(properties.getRetry().getPolicy(), properties.getRetry());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OutboxInstanceRegistry outboxInstanceRegistry(@NotNull OutboxInstanceRepository instanceRepository, @NotNull OutboxProperties properties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)instanceRepository, (String)"instanceRepository");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new OutboxInstanceRegistry(instanceRepository, properties, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public PartitionCoordinator partitionCoordinator(@NotNull OutboxInstanceRegistry instanceRegistry) {
        Intrinsics.checkNotNullParameter((Object)instanceRegistry, (String)"instanceRegistry");
        return new PartitionCoordinator(instanceRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OutboxProcessingScheduler partitionAwareOutboxProcessingScheduler(@NotNull OutboxRecordRepository recordRepository, @NotNull OutboxRecordProcessor recordProcessor, @NotNull PartitionCoordinator partitionCoordinator, @NotNull OutboxInstanceRegistry instanceRegistry, @NotNull OutboxRetryPolicy retryPolicy, @NotNull OutboxProperties properties, @Qualifier(value="outboxTaskExecutor") @NotNull TaskExecutor taskExecutor, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)recordRepository, (String)"recordRepository");
        Intrinsics.checkNotNullParameter((Object)recordProcessor, (String)"recordProcessor");
        Intrinsics.checkNotNullParameter((Object)partitionCoordinator, (String)"partitionCoordinator");
        Intrinsics.checkNotNullParameter((Object)instanceRegistry, (String)"instanceRegistry");
        Intrinsics.checkNotNullParameter((Object)retryPolicy, (String)"retryPolicy");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new OutboxProcessingScheduler(recordRepository, recordProcessor, partitionCoordinator, instanceRegistry, taskExecutor, retryPolicy, properties, clock);
    }

    @Bean(name={"applicationEventMulticaster"})
    @ConditionalOnMissingBean
    @NotNull
    public OutboxEventMulticaster outboxApplicationEventMulticaster(@NotNull BeanFactory beanFactory, @NotNull OutboxRecordRepository outboxRecordRepository, @NotNull OutboxEventSerializer outboxEventSerializer, @NotNull OutboxProperties outboxProperties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        Intrinsics.checkNotNullParameter((Object)outboxRecordRepository, (String)"outboxRecordRepository");
        Intrinsics.checkNotNullParameter((Object)outboxEventSerializer, (String)"outboxEventSerializer");
        Intrinsics.checkNotNullParameter((Object)outboxProperties, (String)"outboxProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new OutboxEventMulticaster(new SimpleApplicationEventMulticaster(beanFactory), outboxRecordRepository, outboxEventSerializer, outboxProperties, clock);
    }
}

