/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.mapper.fn;

import io.mybatis.mapper.fn.Fn;
import io.mybatis.provider.EntityColumn;
import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Reflections {
    private static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    private static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");
    private static final Pattern INSTANTIATED_CLASS_PATTERN = Pattern.compile("\\(L(?<cls>.+);\\).+");

    private Reflections() {
    }

    public static ClassField fnToFieldName(Fn<?, ?> fn) {
        try {
            Class<?> clazz = null;
            if (fn instanceof Fn.FnName) {
                Fn.FnName field = (Fn.FnName)fn;
                if (field.column) {
                    return new ClassColumn(field.entityClass, field.name);
                }
                return new ClassField(field.entityClass, field.name);
            }
            if (fn instanceof Fn.FnImpl) {
                clazz = ((Fn.FnImpl)fn).entityClass;
                fn = ((Fn.FnImpl)fn).fn;
                while (fn instanceof Fn.FnImpl) {
                    fn = ((Fn.FnImpl)fn).fn;
                }
            }
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(fn, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            if (GET_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(3);
            } else if (IS_PATTERN.matcher(getter).matches()) {
                getter = getter.substring(2);
            }
            String field = Introspector.decapitalize(getter);
            if (clazz == null) {
                Matcher matcher = INSTANTIATED_CLASS_PATTERN.matcher(serializedLambda.getInstantiatedMethodType());
                String implClass = matcher.find() ? matcher.group("cls").replaceAll("/", "\\.") : serializedLambda.getImplClass().replaceAll("/", "\\.");
                clazz = Class.forName(implClass);
            }
            return new ClassField(clazz, field);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ClassColumn
    extends ClassField {
        public ClassColumn(Class<?> clazz, String field) {
            super(clazz, field);
        }

        @Override
        public boolean test(EntityColumn column) {
            return this.getField().equalsIgnoreCase(column.column());
        }
    }

    public static class ClassField
    implements Predicate<EntityColumn> {
        private final Class<?> clazz;
        private final String field;

        public ClassField(Class<?> clazz, String field) {
            this.clazz = clazz;
            this.field = field;
        }

        @Override
        public boolean test(EntityColumn column) {
            return this.getField().equalsIgnoreCase(column.property());
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getField() {
            return this.field;
        }
    }
}

