/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.mapper.example;

import io.mybatis.common.util.Assert;
import io.mybatis.mapper.BaseMapper;
import io.mybatis.mapper.example.Example;
import io.mybatis.mapper.fn.Fn;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.session.RowBounds;

public class ExampleWrapper<T, I extends Serializable> {
    private final BaseMapper<T, I> baseMapper;
    private final Example<T> example;
    private Example.Criteria<T> current;

    public ExampleWrapper(BaseMapper<T, I> baseMapper, Example<T> example) {
        this.baseMapper = baseMapper;
        this.example = example;
        this.current = example.createCriteria();
    }

    public ExampleWrapper<T, I> or() {
        this.current = this.example.or();
        return this;
    }

    public Example<T> example() {
        return this.example;
    }

    public ExampleWrapper<T, I> clear() {
        this.example.clear();
        this.current = this.example.createCriteria();
        return this;
    }

    @SafeVarargs
    public final ExampleWrapper<T, I> select(Fn<T, Object> ... fns) {
        this.example.selectColumns(fns);
        return this;
    }

    @SafeVarargs
    public final ExampleWrapper<T, I> exclude(Fn<T, Object> ... fns) {
        this.example.excludeColumns(fns);
        return this;
    }

    public ExampleWrapper<T, I> startSql(String startSql) {
        this.example.setStartSql(startSql);
        return this;
    }

    public ExampleWrapper<T, I> endSql(String endSql) {
        this.example.setEndSql(endSql);
        return this;
    }

    public ExampleWrapper<T, I> orderBy(Fn<T, Object> fn, Example.Order order) {
        this.example.orderBy(fn, order);
        return this;
    }

    public ExampleWrapper<T, I> orderBy(String orderByCondition) {
        this.example.orderBy(orderByCondition);
        return this;
    }

    public ExampleWrapper<T, I> orderBy(Supplier<String> orderByCondition) {
        this.example.orderBy(orderByCondition);
        return this;
    }

    public ExampleWrapper<T, I> orderBy(boolean useOrderBy, Supplier<String> orderByCondition) {
        return useOrderBy ? this.orderBy(orderByCondition) : this;
    }

    @SafeVarargs
    public final ExampleWrapper<T, I> orderByAsc(Fn<T, Object> ... fns) {
        this.example.orderByAsc(fns);
        return this;
    }

    @SafeVarargs
    public final ExampleWrapper<T, I> orderByDesc(Fn<T, Object> ... fns) {
        this.example.orderByDesc(fns);
        return this;
    }

    public ExampleWrapper<T, I> distinct() {
        this.example.setDistinct(true);
        return this;
    }

    public ExampleWrapper<T, I> set(boolean useSet, String setSql) {
        return useSet ? this.set(setSql) : this;
    }

    public ExampleWrapper<T, I> set(String setSql) {
        this.example.set(setSql);
        return this;
    }

    public ExampleWrapper<T, I> set(boolean useSet, Fn<T, Object> fn, Object value) {
        return useSet ? this.set(fn, value) : this;
    }

    public ExampleWrapper<T, I> set(boolean useSet, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useSet ? this.set(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> set(Fn<T, Object> fn, Object value) {
        this.example.set(fn, value);
        return this;
    }

    public ExampleWrapper<T, I> isNull(boolean useCondition, Fn<T, Object> fn) {
        return useCondition ? this.isNull(fn) : this;
    }

    public ExampleWrapper<T, I> isNull(Fn<T, Object> fn) {
        this.current.addCriterion(fn.toColumn() + " IS NULL");
        return this;
    }

    public ExampleWrapper<T, I> isNotNull(boolean useCondition, Fn<T, Object> fn) {
        return useCondition ? this.isNotNull(fn) : this;
    }

    public ExampleWrapper<T, I> isNotNull(Fn<T, Object> fn) {
        this.current.addCriterion(fn.toColumn() + " IS NOT NULL");
        return this;
    }

    public ExampleWrapper<T, I> eq(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.eq(fn, value) : this;
    }

    public ExampleWrapper<T, I> eq(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.eq(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> eq(Fn<T, Object> fn, Object value) {
        this.current.addCriterion(fn.toColumn() + " =", value);
        return this;
    }

    public ExampleWrapper<T, I> ne(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.ne(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> ne(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.ne(fn, value) : this;
    }

    public ExampleWrapper<T, I> ne(Fn<T, Object> fn, Object value) {
        this.current.addCriterion(fn.toColumn() + " <>", value);
        return this;
    }

    public ExampleWrapper<T, I> gt(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.gt(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> gt(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.gt(fn, value) : this;
    }

    public ExampleWrapper<T, I> gt(Fn<T, Object> fn, Object value) {
        this.current.addCriterion(fn.toColumn() + " >", value);
        return this;
    }

    public ExampleWrapper<T, I> ge(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.ge(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> ge(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.ge(fn, value) : this;
    }

    public ExampleWrapper<T, I> ge(Fn<T, Object> fn, Object value) {
        this.current.addCriterion(fn.toColumn() + " >=", value);
        return this;
    }

    public ExampleWrapper<T, I> lt(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.lt(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> lt(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.lt(fn, value) : this;
    }

    public ExampleWrapper<T, I> lt(Fn<T, Object> fn, Object value) {
        this.current.addCriterion(fn.toColumn() + " <", value);
        return this;
    }

    public ExampleWrapper<T, I> le(boolean useCondition, Fn<T, Object> fn, Object value) {
        return useCondition ? this.le(fn, value) : this;
    }

    public ExampleWrapper<T, I> le(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier) {
        return useCondition ? this.le(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> le(Fn<T, Object> fn, Object value) {
        this.current.addCriterion(fn.toColumn() + " <=", value);
        return this;
    }

    public ExampleWrapper<T, I> in(boolean useCondition, Fn<T, Object> fn, Iterable values) {
        return useCondition ? this.in(fn, values) : this;
    }

    public ExampleWrapper<T, I> in(boolean useCondition, Fn<T, Object> fn, Supplier<Iterable> supplier) {
        return useCondition ? this.in(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> in(Fn<T, Object> fn, Iterable values) {
        this.current.addCriterion(fn.toColumn() + " IN", values);
        return this;
    }

    public ExampleWrapper<T, I> notIn(boolean useCondition, Fn<T, Object> fn, Iterable values) {
        return useCondition ? this.notIn(fn, values) : this;
    }

    public ExampleWrapper<T, I> notIn(boolean useCondition, Fn<T, Object> fn, Supplier<Iterable> supplier) {
        return useCondition ? this.notIn(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> notIn(Fn<T, Object> fn, Iterable values) {
        this.current.addCriterion(fn.toColumn() + " NOT IN", values);
        return this;
    }

    public ExampleWrapper<T, I> between(boolean useCondition, Fn<T, Object> fn, Object value1, Object value2) {
        return useCondition ? this.between(fn, value1, value2) : this;
    }

    public ExampleWrapper<T, I> between(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier1, Supplier<Object> supplier2) {
        return useCondition ? this.between(fn, supplier1.get(), supplier2.get()) : this;
    }

    public ExampleWrapper<T, I> between(Fn<T, Object> fn, Object value1, Object value2) {
        this.current.addCriterion(fn.toColumn() + " BETWEEN", value1, value2);
        return this;
    }

    public ExampleWrapper<T, I> notBetween(boolean useCondition, Fn<T, Object> fn, Object value1, Object value2) {
        return useCondition ? this.notBetween(fn, value1, value2) : this;
    }

    public ExampleWrapper<T, I> notBetween(boolean useCondition, Fn<T, Object> fn, Supplier<Object> supplier1, Supplier<Object> supplier2) {
        return useCondition ? this.notBetween(fn, supplier1.get(), supplier2.get()) : this;
    }

    public ExampleWrapper<T, I> notBetween(Fn<T, Object> fn, Object value1, Object value2) {
        this.current.addCriterion(fn.toColumn() + " NOT BETWEEN", value1, value2);
        return this;
    }

    public ExampleWrapper<T, I> contains(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.contains(fn, value) : this;
    }

    public ExampleWrapper<T, I> contains(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.contains(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> contains(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + "  LIKE", "%" + value + "%");
        return this;
    }

    public ExampleWrapper<T, I> startsWith(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.startsWith(fn, value) : this;
    }

    public ExampleWrapper<T, I> startsWith(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.startsWith(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> startsWith(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + "  LIKE", value + "%");
        return this;
    }

    public ExampleWrapper<T, I> endsWith(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.endsWith(fn, value) : this;
    }

    public ExampleWrapper<T, I> endsWith(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.endsWith(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> endsWith(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + "  LIKE", "%" + value);
        return this;
    }

    public ExampleWrapper<T, I> like(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.like(fn, value) : this;
    }

    public ExampleWrapper<T, I> like(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.like(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> like(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + "  LIKE", value);
        return this;
    }

    public ExampleWrapper<T, I> notLike(boolean useCondition, Fn<T, Object> fn, String value) {
        return useCondition ? this.notLike(fn, value) : this;
    }

    public ExampleWrapper<T, I> notLike(boolean useCondition, Fn<T, Object> fn, Supplier<String> supplier) {
        return useCondition ? this.notLike(fn, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> notLike(Fn<T, Object> fn, String value) {
        this.current.addCriterion(fn.toColumn() + "  NOT LIKE", value);
        return this;
    }

    public ExampleWrapper<T, I> anyCondition(boolean useCondition, String condition) {
        return useCondition ? this.anyCondition(condition) : this;
    }

    public ExampleWrapper<T, I> anyCondition(String condition) {
        this.current.andCondition(condition);
        return this;
    }

    public ExampleWrapper<T, I> anyCondition(boolean useCondition, String condition, Object value) {
        return useCondition ? this.anyCondition(condition, value) : this;
    }

    public ExampleWrapper<T, I> anyCondition(boolean useCondition, String condition, Supplier<Object> supplier) {
        return useCondition ? this.anyCondition(condition, supplier.get()) : this;
    }

    public ExampleWrapper<T, I> anyCondition(String condition, Object value) {
        this.current.andCondition(condition, value);
        return this;
    }

    @SafeVarargs
    public final ExampleWrapper<T, I> or(Function<Example.OrCriteria<T>, Example.OrCriteria<T>> ... orParts) {
        if (orParts != null && orParts.length > 0) {
            this.current.andOr(Arrays.stream(orParts).map(orPart -> (Example.OrCriteria)orPart.apply(this.example.orPart())).collect(Collectors.toList()));
        }
        return this;
    }

    public int delete() {
        return this.baseMapper.deleteByExample(this.example);
    }

    public int update() {
        Assert.notEmpty(this.example.getSetValues(), (String)"\u5fc5\u987b\u901a\u8fc7 set \u65b9\u6cd5\u8bbe\u7f6e\u66f4\u65b0\u7684\u5217\u548c\u503c");
        return this.baseMapper.updateByExampleSetValues(this.example);
    }

    public int update(T t) {
        return this.baseMapper.updateByExample(t, this.example);
    }

    public int updateSelective(T t) {
        return this.baseMapper.updateByExampleSelective(t, this.example);
    }

    public List<T> list() {
        return this.baseMapper.selectByExample(this.example);
    }

    public Stream<T> stream() {
        return this.list().stream();
    }

    public Optional<T> one() {
        return this.baseMapper.selectOneByExample(this.example);
    }

    public Optional<T> first() {
        return this.baseMapper.selectByExample(this.example, new RowBounds(0, 1)).stream().findFirst();
    }

    public List<T> top(int n) {
        return this.baseMapper.selectByExample(this.example, new RowBounds(0, n));
    }

    public long count() {
        return this.baseMapper.countByExample(this.example);
    }
}

