/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.mapper.fn;

import io.mybatis.mapper.fn.Reflections;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityFactory;
import io.mybatis.provider.EntityTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Fn<T, R>
extends Function<T, R>,
Serializable {
    public static final Map<Fn<?, ?>, EntityColumn> FN_COLUMN_MAP = new HashMap();
    public static final Map<Fn<?, ?>, Reflections.ClassField> FN_CLASS_FIELD_MAP = new HashMap();

    @SafeVarargs
    public static <E> Fns<E> of(Class<E> entityClass, Fn<E, Object> ... fns) {
        return new Fns((Class)entityClass, (Fn[])fns);
    }

    @SafeVarargs
    public static <E> Fns<E> of(Fn<E, Object> ... fns) {
        return Fn.of(null, fns);
    }

    public static <E> Fns<E> of(Class<E> entityClass, String ... columnNames) {
        EntityTable entityTable = EntityFactory.create(entityClass);
        Set columnNameSet = Arrays.stream(columnNames).collect(Collectors.toSet());
        List columns = entityTable.columns().stream().filter(column -> columnNameSet.contains(column.property())).collect(Collectors.toList());
        return new Fns(entityClass, entityTable.tableName(), columns);
    }

    public static <T> Fn<T, Object> field(Class<T> entityClass, Fn<T, Object> field) {
        return field.in(entityClass);
    }

    public static <T> Fn<T, Object> field(Class<T> entityClass, String field) {
        return new FnName(entityClass, field);
    }

    public static <T> Fn<T, Object> column(Class<T> entityClass, String column) {
        return new FnName(entityClass, column, true);
    }

    default public Fn<T, R> in(Class<?> entityClass) {
        return new FnImpl(this, entityClass);
    }

    default public String toField() {
        return this.toClassField().getField();
    }

    default public String toColumn() {
        return this.toEntityColumn().column();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Reflections.ClassField toClassField() {
        if (!FN_CLASS_FIELD_MAP.containsKey(this)) {
            Fn fn = this;
            synchronized (fn) {
                if (!FN_CLASS_FIELD_MAP.containsKey(this)) {
                    FN_CLASS_FIELD_MAP.put(this, Reflections.fnToFieldName(this));
                }
            }
        }
        return FN_CLASS_FIELD_MAP.get(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public EntityColumn toEntityColumn() {
        if (!FN_COLUMN_MAP.containsKey(this)) {
            Fn fn = this;
            synchronized (fn) {
                if (!FN_COLUMN_MAP.containsKey(this)) {
                    Reflections.ClassField classField = this.toClassField();
                    List columns = EntityFactory.create(classField.getClazz()).columns();
                    EntityColumn entityColumn = columns.stream().filter(column -> column.property().equals(classField.getField())).findFirst().orElseGet(() -> columns.stream().filter(classField).findFirst().orElseThrow(() -> new RuntimeException(classField.getField() + " does not mark database column field annotations, unable to obtain column information")));
                    FN_COLUMN_MAP.put(this, entityColumn);
                }
            }
        }
        return FN_COLUMN_MAP.get(this);
    }

    public static class Fns<E>
    extends EntityTable {
        private Fns(Class<E> entityClass, String table, List<EntityColumn> columns) {
            super(entityClass);
            this.table = table;
            this.columns = columns;
        }

        @SafeVarargs
        private Fns(Class<E> entityClass, Fn<E, Object> ... fns) {
            super(entityClass);
            this.columns = new ArrayList(fns.length);
            for (int i = 0; i < fns.length; ++i) {
                if (entityClass != null) {
                    this.columns.add(fns[i].in(entityClass).toEntityColumn());
                } else {
                    this.columns.add(fns[i].toEntityColumn());
                }
                if (i != 0) continue;
                EntityTable entityTable = ((EntityColumn)this.columns.get(i)).entityTable();
                this.table = entityTable.tableName();
                this.style = entityTable.style();
                this.entityClass = entityTable.entityClass();
                this.resultMap = entityTable.resultMap();
                this.autoResultMap = entityTable.autoResultMap();
            }
        }

        public boolean isNotEmpty() {
            return !this.columns().isEmpty();
        }
    }

    public static class FnName<T, R>
    implements Fn<T, R> {
        final Class<?> entityClass;
        final String name;
        final boolean column;

        public FnName(Class<?> entityClass, String name, boolean column) {
            this.entityClass = entityClass;
            this.name = name;
            this.column = column;
        }

        public FnName(Class<?> entityClass, String name) {
            this(entityClass, name, false);
        }

        @Override
        public Fn<T, R> in(Class<?> entityClass) {
            return new FnName<T, R>(entityClass, this.name, this.column);
        }

        @Override
        public R apply(Object o) {
            return null;
        }
    }

    public static class FnImpl<T, R>
    implements Fn<T, R> {
        final Fn<T, R> fn;
        final Class<?> entityClass;

        public FnImpl(Fn<T, R> fn, Class<?> entityClass) {
            this.fn = fn;
            this.entityClass = entityClass;
        }

        @Override
        public R apply(T t) {
            return this.fn.apply(t);
        }
    }
}

