/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.activerecord.spring.boot.autoconfigure;

import io.mybatis.activerecord.spring.MapperProvider;
import io.mybatis.activerecord.spring.boot.autoconfigure.MapperProviderProperties;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="iomybatis.framework.activerecord", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MapperProviderProperties.class})
public class MapperProviderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MapperProvider springMapperRegistry(SqlSessionTemplate sqlSessionTemplate) {
        return new MapperProvider(sqlSessionTemplate);
    }

    @Configuration
    public static class AutoRegisterConfiguration
    implements InitializingBean {
        private final MapperProvider mapperProvider;

        public AutoRegisterConfiguration(MapperProvider mapperProvider) {
            this.mapperProvider = mapperProvider;
        }

        public void afterPropertiesSet() {
            this.mapperProvider.registerAsDefault();
        }
    }
}

