/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.activerecord.spring;

import io.mybatis.mapper.BaseMapper;
import io.mybatis.provider.EntityClassFinder;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class MapperProvider<T, I extends Serializable, M extends BaseMapper<T, I>>
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    protected static ApplicationContext applicationContext;
    protected Map<Class<?>, BaseMapper<T, I>> modelMapper = new ConcurrentHashMap();
    protected SqlSessionTemplate sqlSessionTemplate;

    public MapperProvider(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public static <T, I extends Serializable, M extends BaseMapper<T, I>> MapperProvider<T, I, M> getDefaultInstance() {
        return MapperProviderInstance.getINSTANCE();
    }

    public static <T, I extends Serializable, M extends BaseMapper<T, I>> MapperProvider<T, I, M> getInstance(String instanceName) {
        return (MapperProvider)applicationContext.getBean(instanceName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        MapperProvider.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.initMapper();
    }

    protected void initMapper() {
        this.sqlSessionTemplate.getConfiguration().getMapperRegistry().getMappers().forEach(mapper -> this.addMapper((Class<?>)mapper, this.sqlSessionTemplate.getMapper(mapper)));
    }

    public void addMapper(Class<?> type, Object mapper) {
        if (type != null && mapper != null && BaseMapper.class.isAssignableFrom(type)) {
            EntityClassFinder.find(type, null).ifPresent(clazz -> {
                if (!this.modelMapper.containsKey(clazz)) {
                    this.modelMapper.put((Class<?>)clazz, (BaseMapper<T, I>)((BaseMapper)mapper));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M baseMapper(Class<T> modelClass) {
        if (!this.modelMapper.containsKey(modelClass)) {
            MapperProvider mapperProvider = this;
            synchronized (mapperProvider) {
                if (!this.modelMapper.containsKey(modelClass)) {
                    this.initMapper();
                }
            }
        }
        if (this.modelMapper.containsKey(modelClass)) {
            return (M)this.modelMapper.get(modelClass);
        }
        throw new RuntimeException(modelClass.getName() + " Mapper interface not found");
    }

    public void registerAsDefault() {
        MapperProviderInstance.setINSTANCE(this);
    }

    private static class MapperProviderInstance {
        public static MapperProvider INSTANCE;

        private MapperProviderInstance() {
        }

        private static <T, I extends Serializable, M extends BaseMapper<T, I>> MapperProvider<T, I, M> getINSTANCE() {
            if (INSTANCE == null) {
                throw new NullPointerException("MapperProvider default instance not found");
            }
            return INSTANCE;
        }

        private static <T, I extends Serializable, M extends BaseMapper<T, I>> void setINSTANCE(MapperProvider<T, I, M> INSTANCE) {
            MapperProviderInstance.INSTANCE = INSTANCE;
        }
    }
}

