/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.activerecord;

import io.mybatis.activerecord.MapperRecord;
import io.mybatis.common.core.Code;
import io.mybatis.common.util.Assert;
import io.mybatis.mapper.BaseMapper;
import io.mybatis.mapper.fn.Fn;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityTable;
import java.io.Serializable;
import java.util.List;

public interface EntityRecord<T, I extends Serializable>
extends MapperRecord<T, I, BaseMapper<T, I>> {
    default public void save() {
        Assert.isTrue((this.baseMapper().insert((Object)this) == 1 ? 1 : 0) != 0, (Code)Code.SAVE_FAILURE);
    }

    default public void saveSelective() {
        Assert.isTrue((this.baseMapper().insertSelective((Object)this) == 1 ? 1 : 0) != 0, (Code)Code.SAVE_FAILURE);
    }

    default public void update() {
        Assert.isTrue((this.baseMapper().updateByPrimaryKey((Object)this) == 1 ? 1 : 0) != 0, (Code)Code.UPDATE_FAILURE);
    }

    default public void updateSelective() {
        Assert.isTrue((this.baseMapper().updateByPrimaryKeySelective((Object)this) == 1 ? 1 : 0) != 0, (Code)Code.UPDATE_FAILURE);
    }

    default public void updateSelective(Fn<T, Object> ... forceUpdateFields) {
        Assert.isTrue((this.baseMapper().updateByPrimaryKeySelectiveWithForceFields((Object)this, Fn.of(forceUpdateFields)) == 1 ? 1 : 0) != 0, (Code)Code.UPDATE_FAILURE);
    }

    default public I pkValue() {
        EntityTable entityTable = this.baseMapper().entityTable();
        List idColumns = entityTable.idColumns();
        if (idColumns.size() == 1) {
            return (I)((Serializable)((EntityColumn)idColumns.get(0)).field().get((Object)this));
        }
        return (I)(((EntityColumn)idColumns.get(0)).field().get((Object)this) != null ? (Serializable)((Object)this) : null);
    }

    default public boolean pkHasValue() {
        return this.pkValue() != null;
    }

    default public void saveOrUpdate() {
        if (this.pkHasValue()) {
            this.update();
        } else {
            this.save();
        }
    }

    default public void saveOrUpdateSelective() {
        if (this.pkHasValue()) {
            this.updateSelective();
        } else {
            this.saveSelective();
        }
    }

    default public int delete() {
        return this.baseMapper().delete((Object)this);
    }

    default public void deleteById() {
        Assert.isTrue((this.baseMapper().deleteByPrimaryKey(this.pkValue()) == 1 ? 1 : 0) != 0, (Code)Code.DELETE_FAILURE);
    }

    default public void deleteById(I id) {
        Assert.isTrue((this.baseMapper().deleteByPrimaryKey(id) == 1 ? 1 : 0) != 0, (Code)Code.DELETE_FAILURE);
    }

    default public <F> int deleteByFieldList(Fn<T, F> field, List<F> fieldValueList) {
        return this.baseMapper().deleteByFieldList(field, fieldValueList);
    }

    default public T findById(I id) {
        return this.baseMapper().selectByPrimaryKey(id).orElse(null);
    }

    default public T findOne() {
        return this.baseMapper().selectOne((Object)this).orElse(null);
    }

    default public List<T> findList() {
        return this.baseMapper().selectList((Object)this);
    }

    default public <F> List<T> findByFieldList(Fn<T, F> field, List<F> fieldValueList) {
        return this.baseMapper().selectByFieldList(field, fieldValueList);
    }

    default public List<T> findAll() {
        return this.baseMapper().selectList(null);
    }

    default public long count() {
        return this.baseMapper().selectCount((Object)this);
    }
}

