/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.plotter.cli.internal;

import io.hotmoka.cli.AbstractCommand;
import io.hotmoka.cli.CommandException;
import io.mokamint.plotter.Plots;
import io.mokamint.plotter.api.Plot;
import jakarta.websocket.EncodeException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show a plot file."}, showDefaultValues=true)
public class Show
extends AbstractCommand {
    @CommandLine.Parameters(index="0", description={"the path of the plot file"})
    private Path path;
    @CommandLine.Option(names={"--json"}, description={"print the output in JSON"}, defaultValue="false")
    private boolean json;

    protected void execute() throws CommandException {
        block12: {
            try (Plot plot = Plots.load((Path)this.path);){
                if (this.json) {
                    try {
                        System.out.println(new Plots.Encoder().encode((Object)plot));
                        break block12;
                    }
                    catch (EncodeException e) {
                        throw new CommandException("Cannot encode the plot in JSON format!", (Throwable)e);
                    }
                }
                System.out.println(plot);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CommandException("The plot file uses an unknown cryptographic algorithm!", (Throwable)e);
            }
            catch (IOException e) {
                throw new CommandException("Cannot access the plot file!", (Throwable)e);
            }
        }
    }
}

