/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.plotter.cli.internal;

import io.hotmoka.cli.AbstractCommand;
import io.hotmoka.cli.CommandException;
import io.hotmoka.crypto.Base58;
import io.hotmoka.crypto.Base58ConversionException;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.mokamint.nonce.Prologs;
import io.mokamint.nonce.api.Prolog;
import io.mokamint.plotter.Plots;
import io.mokamint.plotter.api.Plot;
import io.mokamint.plotter.cli.internal.HashingOptionConverter;
import io.mokamint.plotter.cli.internal.SignatureOptionConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a new plot file."}, showDefaultValues=true)
public class Create
extends AbstractCommand {
    @CommandLine.Parameters(index="0", description={"the path of the new plot file"})
    private Path path;
    @CommandLine.Parameters(index="1", description={"the initial nonce number"})
    private long start;
    @CommandLine.Parameters(index="2", description={"the amount of nonces"})
    private long length;
    @CommandLine.Parameters(index="3", description={"the chain identifier of the network for which the plot will be used"})
    private String chainId;
    @CommandLine.Parameters(index="4", description={"the base58-encoded public key of the node for which the plot will be used"})
    private String nodePublicKeyBase58;
    @CommandLine.Parameters(index="5", description={"the base58-encoded public key of the plot"})
    private String plotPublicKeyBase58;
    @CommandLine.Option(names={"--extra"}, description={"application-specific base58-encoded extra data for the plot"}, defaultValue="")
    private String extraBase58;
    @CommandLine.Option(names={"--hashing"}, description={"the hashing algorithm for the nonces"}, converter={HashingOptionConverter.class}, defaultValue="shabal256")
    private HashingAlgorithm hashing;
    @CommandLine.Option(names={"--signature-of-node"}, description={"the signature algorithm used for nodePublicKeyBase58"}, converter={SignatureOptionConverter.class}, defaultValue="ed25519")
    private SignatureAlgorithm signatureOfNode;
    @CommandLine.Option(names={"--signature-of-plot"}, description={"the signature algorithm used for plotPublicKeyBase58"}, converter={SignatureOptionConverter.class}, defaultValue="ed25519")
    private SignatureAlgorithm signatureOfPlot;

    protected void execute() throws CommandException {
        Prolog prolog;
        try {
            Files.deleteIfExists(this.path);
        }
        catch (IOException e) {
            throw new CommandException("Failed to overwrite \"" + String.valueOf(this.path) + "\"!", (Throwable)e);
        }
        try {
            prolog = this.computeProlog();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommandException("The ed25519 signature algorithm is not available!", (Throwable)e);
        }
        catch (InvalidKeyException | InvalidKeySpecException e) {
            throw new CommandException("Invalid public key!", (Throwable)e);
        }
        try {
            Plot plot = Plots.create((Path)this.path, (Prolog)prolog, (long)this.start, (long)this.length, (HashingAlgorithm)this.hashing, this::onNewPercent);
            if (plot != null) {
                plot.close();
            }
        }
        catch (InterruptedException e) {
            throw new CommandException("Interrupted while waiting!", (Throwable)e);
        }
        catch (IOException e) {
            throw new CommandException("Cannot write the plot file!", (Throwable)e);
        }
        System.out.println();
    }

    private void onNewPercent(int percent) {
        if (percent % 5 == 0) {
            System.out.print(CommandLine.Help.Ansi.AUTO.string("@|bold,red " + percent + "%|@ "));
        } else {
            System.out.print(percent + "% ");
        }
    }

    private Prolog computeProlog() throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, CommandException {
        return Prologs.of((String)this.chainId, (SignatureAlgorithm)this.signatureOfNode, (PublicKey)this.signatureOfNode.publicKeyFromEncoding(this.bytesFromBase58(this.nodePublicKeyBase58)), (SignatureAlgorithm)this.signatureOfPlot, (PublicKey)this.signatureOfPlot.publicKeyFromEncoding(this.bytesFromBase58(this.plotPublicKeyBase58)), (byte[])this.bytesFromBase58(this.extraBase58));
    }

    private byte[] bytesFromBase58(String base58) throws CommandException {
        try {
            return Base58.decode((String)base58);
        }
        catch (Base58ConversionException e) {
            throw new CommandException("The string " + base58 + " is not in Base58 format!", (Throwable)e);
        }
    }
}

