/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal.json;

import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.hotmoka.websockets.beans.api.JsonRepresentation;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.internal.BasicConsensusConfigBuilder;
import java.security.NoSuchAlgorithmException;

public abstract class BasicConsensusConfigJson
implements JsonRepresentation<ConsensusConfig<?, ?>> {
    private final String chainId;
    private final String hashingForDeadlines;
    private final String hashingForGenerations;
    private final String hashingForBlocks;
    private final String hashingForTransactions;
    private final String signatureForBlocks;
    private final String signatureForDeadlines;
    private final int targetBlockCreationTime;
    private final int maxBlockSize;
    private final int oblivion;

    protected BasicConsensusConfigJson(ConsensusConfig<?, ?> config) {
        this.chainId = config.getChainId();
        this.hashingForDeadlines = config.getHashingForDeadlines().getName();
        this.hashingForGenerations = config.getHashingForGenerations().getName();
        this.hashingForBlocks = config.getHashingForBlocks().getName();
        this.hashingForTransactions = config.getHashingForTransactions().getName();
        this.signatureForBlocks = config.getSignatureForBlocks().getName();
        this.signatureForDeadlines = config.getSignatureForDeadlines().getName();
        this.targetBlockCreationTime = config.getTargetBlockCreationTime();
        this.maxBlockSize = config.getMaxBlockSize();
        this.oblivion = config.getOblivion();
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getHashingForDeadlines() {
        return this.hashingForDeadlines;
    }

    public String getHashingForGenerations() {
        return this.hashingForGenerations;
    }

    public String getHashingForBlocks() {
        return this.hashingForBlocks;
    }

    public String getHashingForTransactions() {
        return this.hashingForTransactions;
    }

    public String getSignatureForBlocks() {
        return this.signatureForBlocks;
    }

    public String getSignatureForDeadlines() {
        return this.signatureForDeadlines;
    }

    public int getTargetBlockCreationTime() {
        return this.targetBlockCreationTime;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public int getOblivion() {
        return this.oblivion;
    }

    public ConsensusConfig<?, ?> unmap() throws NoSuchAlgorithmException, InconsistentJsonException {
        return new BasicConsensusConfigBuilder(this).build();
    }
}

