/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.Version;
import io.mokamint.node.internal.json.VersionJson;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.stream.Stream;

public class VersionImpl
implements Version {
    private final int major;
    private final int minor;
    private final int patch;

    public VersionImpl(int major, int minor, int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Version's components must be non-negative");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public VersionImpl(VersionJson json) throws InconsistentJsonException {
        int major = json.getMajor();
        int minor = json.getMinor();
        int patch = json.getPatch();
        if (major < 0 || minor < 0 || patch < 0) {
            throw new InconsistentJsonException("Version's components must be non-negative");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public VersionImpl() throws IOException {
        try (InputStream is = VersionImpl.class.getClassLoader().getResourceAsStream("maven.properties");){
            Properties mavenProperties = new Properties();
            mavenProperties.load(is);
            int[] components = Stream.of(mavenProperties.getProperty("mokamint.version").split("\\.")).mapToInt(Integer::parseInt).toArray();
            if (components.length != 3) {
                throw new IOException("The mokamint.version property of the maven.properties file should consist of three integer components, while I found " + components.length);
            }
            this.major = components[0];
            this.minor = components[1];
            this.patch = components[2];
            if (this.major < 0 || this.minor < 0 || this.patch < 0) {
                throw new IOException("Version's components must be non-negative");
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean equals(Object other) {
        Version otherAsVersion;
        return other instanceof Version && this.major == (otherAsVersion = (Version)other).getMajor() && this.minor == otherAsVersion.getMinor() && this.patch == otherAsVersion.getPatch();
    }

    public int hashCode() {
        return this.major + this.minor + this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public boolean canWorkWith(Version other) {
        return this.major == other.getMajor() && this.minor == other.getMinor();
    }
}

