/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.TransactionAddress;
import io.mokamint.node.internal.json.TransactionAddressJson;
import java.util.Arrays;
import java.util.Objects;

public class TransactionAddressImpl
implements TransactionAddress {
    private final byte[] blockHash;
    private final int progressive;

    public TransactionAddressImpl(byte[] blockHash, int progressive) {
        if (progressive < 0) {
            throw new IllegalArgumentException("progressive cannot be negative");
        }
        this.progressive = progressive;
        this.blockHash = (byte[])Objects.requireNonNull(blockHash).clone();
    }

    public TransactionAddressImpl(TransactionAddressJson json) throws InconsistentJsonException {
        int progressive = json.getProgressive();
        if (progressive < 0) {
            throw new InconsistentJsonException("progressive cannot be negative");
        }
        String blockHash = json.getBlockHash();
        if (blockHash == null) {
            throw new InconsistentJsonException("blockHash cannot be null");
        }
        try {
            this.blockHash = Hex.fromHexString((String)blockHash);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        this.progressive = progressive;
    }

    public byte[] getBlockHash() {
        return (byte[])this.blockHash.clone();
    }

    public int getProgressive() {
        return this.progressive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        byte[] byArray;
        if (!(other instanceof TransactionAddress)) return false;
        TransactionAddress ta = (TransactionAddress)other;
        if (ta.getProgressive() != this.progressive) return false;
        if (ta instanceof TransactionAddressImpl) {
            TransactionAddressImpl tai = (TransactionAddressImpl)ta;
            byArray = tai.blockHash;
        } else {
            byArray = ta.getBlockHash();
        }
        if (!Arrays.equals(byArray, this.blockHash)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.blockHash) ^ this.progressive;
    }

    public String toString() {
        return "#" + this.progressive + "@" + Hex.toHexString((byte[])this.blockHash);
    }
}

