/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.MempoolEntry;
import io.mokamint.node.internal.json.MempoolEntryJson;
import java.util.Arrays;
import java.util.Objects;

public class MempoolEntryImpl
implements MempoolEntry {
    private final byte[] hash;
    private final long priority;

    public MempoolEntryImpl(byte[] hash, long priority) {
        this.hash = (byte[])Objects.requireNonNull(hash).clone();
        this.priority = priority;
    }

    public MempoolEntryImpl(MempoolEntryJson json) throws InconsistentJsonException {
        String hash = json.getHash();
        if (hash == null) {
            throw new InconsistentJsonException("hash cannot be null");
        }
        try {
            this.hash = Hex.fromHexString((String)hash);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        this.priority = json.getPriority();
    }

    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    public long getPriority() {
        return this.priority;
    }

    public boolean equals(Object other) {
        MempoolEntry ti;
        if (other instanceof MempoolEntryImpl) {
            MempoolEntryImpl mei = (MempoolEntryImpl)other;
            return Arrays.equals(this.hash, mei.hash);
        }
        return other instanceof MempoolEntry && Arrays.equals(this.hash, (ti = (MempoolEntry)other).getHash());
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }

    public String toString() {
        return Hex.toHexString((byte[])this.hash) + " with priority " + this.priority;
    }
}

