/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Base64;
import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.mokamint.node.api.Transaction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public class TransactionImpl
extends AbstractMarshallable
implements Transaction {
    private final byte[] bytes;

    public TransactionImpl(byte[] bytes) {
        this.bytes = (byte[])Objects.requireNonNull(bytes).clone();
    }

    public TransactionImpl(UnmarshallingContext context) throws IOException {
        this(context.readLengthAndBytes("Transaction length mismatch"));
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public int getNumberOfBytes() {
        return this.bytes.length;
    }

    public String toBase64String() {
        return Base64.toBase64String((byte[])this.bytes);
    }

    public String getHexHash(HashingAlgorithm hashing) {
        return Hex.toHexString((byte[])this.getHash(hashing));
    }

    public byte[] getHash(HashingAlgorithm hashing) {
        return hashing.getHasher(Function.identity()).hash((Object)this.bytes);
    }

    public boolean equals(Object other) {
        Transaction t;
        if (other instanceof TransactionImpl) {
            TransactionImpl ti = (TransactionImpl)((Object)other);
            return Arrays.equals(this.bytes, ti.bytes);
        }
        return other instanceof Transaction && Arrays.equals(this.bytes, (t = (Transaction)other).getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public void into(MarshallingContext context) throws IOException {
        context.writeLengthAndBytes(this.bytes);
    }

    public String toString() {
        return this.toBase64String() + " (base64)";
    }

    public int compareTo(Transaction other) {
        if (other instanceof TransactionImpl) {
            TransactionImpl ti = (TransactionImpl)other;
            return Arrays.compare(this.bytes, ti.bytes);
        }
        return Arrays.compare(this.bytes, other.getBytes());
    }
}

