/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.exceptions.ExceptionSupplierFromMessage;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.Peer;
import io.mokamint.node.internal.json.PeerJson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class PeerImpl
extends AbstractMarshallable
implements Peer {
    private final URI uri;

    public PeerImpl(URI uri) {
        this(((URI)Objects.requireNonNull((Object)uri, (String)"uri cannot be null", IllegalArgumentException::new)).toString(), IllegalArgumentException::new);
    }

    public PeerImpl(PeerJson json) throws InconsistentJsonException {
        this((String)Objects.requireNonNull((Object)json.getUri(), (String)"uri cannot be null", InconsistentJsonException::new), InconsistentJsonException::new);
    }

    public PeerImpl(UnmarshallingContext context) throws IOException {
        this(context.readStringUnshared(), IOException::new);
    }

    private <E extends Exception> PeerImpl(String uri, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        try {
            this.uri = new URI((String)Objects.requireNonNull((Object)uri, (String)"uri cannot be null", onIllegalArgs));
        }
        catch (URISyntaxException e) {
            throw (Exception)onIllegalArgs.apply((Object)e.getMessage());
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean equals(Object other) {
        Peer peer;
        return other instanceof Peer && this.uri.equals((peer = (Peer)other).getURI());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public void into(MarshallingContext context) throws IOException {
        context.writeStringUnshared(this.uri.toString());
    }

    public int compareTo(Peer other) {
        return this.uri.compareTo(other.getURI());
    }

    public String toString() {
        String uri = this.uri.toString();
        return uri.length() > 100 ? uri.substring(0, 100) + "..." : uri;
    }
}

