/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.api.NonGenesisBlockDescription;
import io.mokamint.node.internal.AbstractBlockDescription;
import io.mokamint.node.internal.json.BlockDescriptionJson;
import io.mokamint.nonce.Deadlines;
import io.mokamint.nonce.api.Challenge;
import io.mokamint.nonce.api.Deadline;
import io.mokamint.nonce.api.Prolog;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public non-sealed class NonGenesisBlockDescriptionImpl
extends AbstractBlockDescription
implements NonGenesisBlockDescription {
    private final long height;
    private final BigInteger power;
    private final long totalWaitingTime;
    private final long weightedWaitingTime;
    private final BigInteger acceleration;
    private final Deadline deadline;
    private final byte[] hashOfPreviousBlock;

    public NonGenesisBlockDescriptionImpl(long height, BigInteger power, long totalWaitingTime, long weightedWaitingTime, BigInteger acceleration, Deadline deadline, byte[] hashOfPreviousBlock, int targetBlockCreationTime, int oblivion, HashingAlgorithm hashingForBlocks, HashingAlgorithm hashingForTransactions) {
        super(targetBlockCreationTime, oblivion, hashingForBlocks, hashingForTransactions);
        this.height = height;
        this.power = Objects.requireNonNull(power);
        this.totalWaitingTime = totalWaitingTime;
        this.weightedWaitingTime = weightedWaitingTime;
        this.acceleration = Objects.requireNonNull(acceleration);
        this.deadline = Objects.requireNonNull(deadline);
        this.hashOfPreviousBlock = (byte[])Objects.requireNonNull(hashOfPreviousBlock).clone();
        if (height < 1L) {
            throw new IllegalArgumentException("A non-genesis block must have positive height");
        }
        if (power.signum() < 0) {
            throw new IllegalArgumentException("power cannot be negative");
        }
        if (acceleration.signum() <= 0) {
            throw new IllegalArgumentException("acceleration must be strictly positive");
        }
        if (weightedWaitingTime < 0L) {
            throw new IllegalArgumentException("weightedWaitingTime cannot be negative");
        }
        if (totalWaitingTime < weightedWaitingTime) {
            throw new IllegalArgumentException("The total waiting time cannot be smaller than the weighted waiting time");
        }
        if (hashOfPreviousBlock.length != this.getHashingForBlocks().length()) {
            throw new IllegalArgumentException("Length mismatch in the hash of the previous block: expected " + this.getHashingForBlocks().length() + " but found " + hashOfPreviousBlock.length);
        }
    }

    protected NonGenesisBlockDescriptionImpl(BlockDescriptionJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
        super(json);
        Long height = json.getHeight();
        if (height == null) {
            throw new InconsistentJsonException("height cannot be null");
        }
        this.height = height;
        if (this.height <= 0L) {
            throw new InconsistentJsonException("A non-genesis block must have positive height");
        }
        this.acceleration = json.getAcceleration();
        if (this.acceleration == null) {
            throw new InconsistentJsonException("acceleration cannot be null");
        }
        if (this.acceleration.signum() <= 0) {
            throw new InconsistentJsonException("acceleration must be strictly positive");
        }
        this.power = json.getPower();
        if (this.power == null) {
            throw new InconsistentJsonException("power cannot be null");
        }
        if (this.power.signum() < 0) {
            throw new InconsistentJsonException("power cannot be negative");
        }
        String hashOfPreviousBlock = json.getHashOfPreviousBlock();
        if (hashOfPreviousBlock == null) {
            throw new InconsistentJsonException("hashOfPreviousBlock cannot be null");
        }
        try {
            this.hashOfPreviousBlock = Hex.fromHexString((String)hashOfPreviousBlock);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        if (this.hashOfPreviousBlock.length != this.getHashingForBlocks().length()) {
            throw new InconsistentJsonException("Length mismatch in the hash of the previous block: expected " + this.getHashingForBlocks().length() + " but found " + this.hashOfPreviousBlock.length);
        }
        Long weightedWaitingTime = json.getWeightedWaitingTime();
        if (weightedWaitingTime == null) {
            throw new InconsistentJsonException("weightedWaitingTime cannot be null");
        }
        this.weightedWaitingTime = weightedWaitingTime;
        if (this.weightedWaitingTime < 0L) {
            throw new InconsistentJsonException("weightedWaitingTime cannot be negative");
        }
        Deadlines.Json deadline = json.getDeadline();
        if (deadline == null) {
            throw new InconsistentJsonException("deadline cannot be null");
        }
        this.deadline = deadline.unmap();
        Long totalWaitingTime = json.getTotalWaitingTime();
        if (totalWaitingTime == null) {
            throw new InconsistentJsonException("totalWaitingTime cannot be null");
        }
        this.totalWaitingTime = totalWaitingTime;
        if (this.totalWaitingTime < this.weightedWaitingTime) {
            throw new InconsistentJsonException("The total waiting time cannot be smaller than the weighted waiting time");
        }
    }

    protected NonGenesisBlockDescriptionImpl(long height, UnmarshallingContext context) throws IOException, NoSuchAlgorithmException {
        super(context);
        this.height = height;
        this.power = context.readBigInteger();
        this.totalWaitingTime = context.readLong();
        this.weightedWaitingTime = context.readCompactLong();
        this.acceleration = context.readBigInteger();
        this.deadline = Deadlines.from((UnmarshallingContext)context);
        this.hashOfPreviousBlock = context.readBytes(this.getHashingForBlocks().length(), "Previous block hash length mismatch");
        if (height < 1L) {
            throw new IOException("A non-genesis block must have positive height");
        }
        if (this.power.signum() < 0) {
            throw new IOException("power cannot be negative");
        }
        if (this.acceleration.signum() <= 0) {
            throw new IOException("acceleration must be strictly positive");
        }
        if (this.weightedWaitingTime < 0L) {
            throw new IOException("weightedWaitingTime cannot be negative");
        }
        if (this.totalWaitingTime < this.weightedWaitingTime) {
            throw new IOException("The total waiting time cannot be smaller than the weighted waiting time");
        }
    }

    protected NonGenesisBlockDescriptionImpl(long height, UnmarshallingContext context, ConsensusConfig<?, ?> config) throws IOException {
        super(config);
        this.height = height;
        this.power = context.readBigInteger();
        this.totalWaitingTime = context.readLong();
        this.weightedWaitingTime = context.readCompactLong();
        this.acceleration = context.readBigInteger();
        this.deadline = Deadlines.from((UnmarshallingContext)context, (String)config.getChainId(), (HashingAlgorithm)config.getHashingForDeadlines(), (HashingAlgorithm)config.getHashingForGenerations(), (SignatureAlgorithm)config.getSignatureForBlocks(), (SignatureAlgorithm)config.getSignatureForDeadlines());
        this.hashOfPreviousBlock = context.readBytes(this.getHashingForBlocks().length(), "Previous block hash length mismatch");
        if (height < 1L) {
            throw new IOException("A non-genesis block must have positive height");
        }
        if (this.power.signum() < 0) {
            throw new IOException("power cannot be negative");
        }
        if (this.acceleration.signum() <= 0) {
            throw new IOException("acceleration must be strictly positive");
        }
        if (this.weightedWaitingTime < 0L) {
            throw new IOException("weightedWaitingTime cannot be negative");
        }
        if (this.totalWaitingTime < this.weightedWaitingTime) {
            throw new IOException("The total waiting time cannot be smaller than the weighted waiting time");
        }
    }

    public BigInteger getPower() {
        return this.power;
    }

    public long getTotalWaitingTime() {
        return this.totalWaitingTime;
    }

    public long getWeightedWaitingTime() {
        return this.weightedWaitingTime;
    }

    public BigInteger getAcceleration() {
        return this.acceleration;
    }

    public long getHeight() {
        return this.height;
    }

    public HashingAlgorithm getHashingForDeadlines() {
        return this.deadline.getChallenge().getHashingForDeadlines();
    }

    public HashingAlgorithm getHashingForGenerations() {
        return this.deadline.getChallenge().getHashingForGenerations();
    }

    public SignatureAlgorithm getSignatureForBlocks() {
        return this.deadline.getProlog().getSignatureForBlocks();
    }

    public PublicKey getPublicKeyForSigningBlock() {
        return this.deadline.getProlog().getPublicKeyForSigningBlocks();
    }

    public String getPublicKeyForSigningBlockBase58() {
        return this.deadline.getProlog().getPublicKeyForSigningBlocksBase58();
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public byte[] getHashOfPreviousBlock() {
        return (byte[])this.hashOfPreviousBlock.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        byte[] byArray;
        if (!(other instanceof NonGenesisBlockDescription)) return false;
        NonGenesisBlockDescription ngbd = (NonGenesisBlockDescription)other;
        if (!super.equals(other)) return false;
        if (this.height != ngbd.getHeight()) return false;
        if (!this.power.equals(ngbd.getPower())) return false;
        if (this.totalWaitingTime != ngbd.getTotalWaitingTime()) return false;
        if (this.weightedWaitingTime != ngbd.getWeightedWaitingTime()) return false;
        if (!this.acceleration.equals(ngbd.getAcceleration())) return false;
        if (!this.deadline.equals((Object)ngbd.getDeadline())) return false;
        if (!this.getHashingForBlocks().equals((Object)ngbd.getHashingForBlocks())) return false;
        if (other instanceof NonGenesisBlockDescriptionImpl) {
            NonGenesisBlockDescriptionImpl ngbdi = (NonGenesisBlockDescriptionImpl)((Object)other);
            byArray = ngbdi.hashOfPreviousBlock;
        } else {
            byArray = ngbd.getHashOfPreviousBlock();
        }
        if (!Arrays.equals(this.hashOfPreviousBlock, byArray)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.height) ^ this.power.hashCode() ^ Long.hashCode(this.totalWaitingTime) ^ Long.hashCode(this.weightedWaitingTime) ^ this.acceleration.hashCode() ^ this.deadline.hashCode();
    }

    @Override
    public void into(MarshallingContext context) throws IOException {
        super.into(context);
        context.writeBigInteger(this.power);
        context.writeLong(this.totalWaitingTime);
        context.writeCompactLong(this.weightedWaitingTime);
        context.writeBigInteger(this.acceleration);
        this.deadline.into(context);
        context.writeBytes(this.hashOfPreviousBlock);
    }

    @Override
    public void intoWithoutConfigurationData(MarshallingContext context) throws IOException {
        super.intoWithoutConfigurationData(context);
        context.writeBigInteger(this.power);
        context.writeLong(this.totalWaitingTime);
        context.writeCompactLong(this.weightedWaitingTime);
        context.writeBigInteger(this.acceleration);
        this.deadline.intoWithoutConfigurationData(context);
        context.writeBytes(this.hashOfPreviousBlock);
    }

    @Override
    protected void populate(StringBuilder builder) {
        super.populate(builder);
        builder.append("\n* hash of previous block: " + Hex.toHexString((byte[])this.hashOfPreviousBlock) + " (" + String.valueOf(this.getHashingForBlocks()) + ")\n");
        builder.append("* deadline:\n");
        builder.append("  * prolog:\n");
        Prolog prolog = this.deadline.getProlog();
        builder.append("    * chain identifier: " + prolog.getChainId() + "\n");
        builder.append("    * public key of the node that signed the block: " + prolog.getPublicKeyForSigningBlocksBase58() + " (" + String.valueOf(prolog.getSignatureForBlocks()) + ", base58)\n");
        builder.append("    * public key of the miner that signed the deadline: " + prolog.getPublicKeyForSigningDeadlinesBase58() + " (" + String.valueOf(prolog.getSignatureForDeadlines()) + ", base58)\n");
        builder.append("    * extra: " + Hex.toHexString((byte[])prolog.getExtra()) + "\n");
        builder.append("  * challenge:\n");
        Challenge challenge = this.deadline.getChallenge();
        builder.append("    * scoopNumber: " + challenge.getScoopNumber() + "\n");
        builder.append("    * generation signature: " + Hex.toHexString((byte[])challenge.getGenerationSignature()) + " (" + String.valueOf(challenge.getHashingForGenerations()) + ")\n");
        builder.append("  * nonce: " + this.deadline.getProgressive() + "\n");
        builder.append("  * value: " + Hex.toHexString((byte[])this.deadline.getValue()) + " (" + String.valueOf(challenge.getHashingForDeadlines()) + ")\n");
        builder.append("  * miner's signature: " + Hex.toHexString((byte[])this.deadline.getSignature()) + " (" + String.valueOf(prolog.getSignatureForDeadlines()) + ")");
    }

    @Override
    protected byte[] getNextGenerationSignature() {
        Challenge challenge = this.deadline.getChallenge();
        byte[] previousGenerationSignature = challenge.getGenerationSignature();
        byte[] previousProlog = this.deadline.getProlog().toByteArray();
        return challenge.getHashingForGenerations().getHasher(Function.identity()).hash((Object)NonGenesisBlockDescriptionImpl.concat(previousGenerationSignature, previousProlog));
    }
}

