/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal.gson;

import io.hotmoka.crypto.Hex;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.hotmoka.websockets.beans.api.JsonRepresentation;
import io.mokamint.node.BlockDescriptions;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.api.Transaction;
import io.mokamint.node.internal.AbstractBlock;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;

public abstract class BlockJson
implements JsonRepresentation<Block> {
    private final BlockDescriptions.Json description;
    private final String[] transactions;
    private final String stateId;
    private final String signature;

    protected BlockJson(Block block) {
        String[] stringArray;
        this.description = new BlockDescriptions.Json(block.getDescription());
        if (block instanceof NonGenesisBlock) {
            NonGenesisBlock ngb = (NonGenesisBlock)block;
            stringArray = (String[])ngb.getTransactions().map(Transaction::toBase64String).toArray(String[]::new);
        } else {
            stringArray = null;
        }
        this.transactions = stringArray;
        this.stateId = Hex.toHexString((byte[])block.getStateId());
        this.signature = Hex.toHexString((byte[])block.getSignature());
    }

    public BlockDescriptions.Json getDescription() {
        return this.description;
    }

    public String getStateId() {
        return this.stateId;
    }

    public String getSignature() {
        return this.signature;
    }

    public Stream<String> getTransactions() {
        return this.transactions == null ? Stream.empty() : Stream.of(this.transactions);
    }

    public Block unmap() throws NoSuchAlgorithmException, InconsistentJsonException {
        return AbstractBlock.from(this);
    }
}

