/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal.gson;

import io.hotmoka.crypto.Hex;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.hotmoka.websockets.beans.api.JsonRepresentation;
import io.mokamint.node.api.BlockDescription;
import io.mokamint.node.api.GenesisBlockDescription;
import io.mokamint.node.api.NonGenesisBlockDescription;
import io.mokamint.node.internal.AbstractBlockDescription;
import io.mokamint.nonce.Deadlines;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.time.format.DateTimeFormatter;

public abstract class BlockDescriptionJson
implements JsonRepresentation<BlockDescription> {
    private String startDateTimeUTC;
    private Long height;
    private BigInteger power;
    private Long totalWaitingTime;
    private Long weightedWaitingTime;
    private BigInteger acceleration;
    private Deadlines.Json deadline;
    private final int targetBlockCreationTime;
    private final int oblivion;
    private final String hashingForBlocks;
    private String hashingForDeadlines;
    private String hashingForGenerations;
    private final String hashingForTransactions;
    private String hashOfPreviousBlock;
    private String signatureForBlocks;
    private String publicKey;

    protected BlockDescriptionJson(BlockDescription description) {
        this.targetBlockCreationTime = description.getTargetBlockCreationTime();
        this.oblivion = description.getOblivion();
        this.hashingForBlocks = description.getHashingForBlocks().getName();
        this.hashingForTransactions = description.getHashingForTransactions().getName();
        if (description instanceof GenesisBlockDescription) {
            GenesisBlockDescription gbd = (GenesisBlockDescription)description;
            this.startDateTimeUTC = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(gbd.getStartDateTimeUTC());
            this.hashingForDeadlines = gbd.getHashingForDeadlines().getName();
            this.hashingForGenerations = gbd.getHashingForGenerations().getName();
            this.signatureForBlocks = gbd.getSignatureForBlocks().getName();
            this.publicKey = gbd.getPublicKeyForSigningBlockBase58();
        } else {
            NonGenesisBlockDescription ngbd = (NonGenesisBlockDescription)description;
            this.height = ngbd.getHeight();
            this.power = ngbd.getPower();
            this.totalWaitingTime = ngbd.getTotalWaitingTime();
            this.weightedWaitingTime = ngbd.getWeightedWaitingTime();
            this.acceleration = ngbd.getAcceleration();
            this.deadline = new Deadlines.Json(ngbd.getDeadline());
            this.hashOfPreviousBlock = Hex.toHexString((byte[])ngbd.getHashOfPreviousBlock());
        }
    }

    public Long getHeight() {
        return this.height;
    }

    public BigInteger getPower() {
        return this.power;
    }

    public Long getTotalWaitingTime() {
        return this.totalWaitingTime;
    }

    public Long getWeightedWaitingTime() {
        return this.weightedWaitingTime;
    }

    public BigInteger getAcceleration() {
        return this.acceleration;
    }

    public Deadlines.Json getDeadline() {
        return this.deadline;
    }

    public String getHashOfPreviousBlock() {
        return this.hashOfPreviousBlock;
    }

    public String getStartDateTimeUTC() {
        return this.startDateTimeUTC;
    }

    public int getTargetBlockCreationTime() {
        return this.targetBlockCreationTime;
    }

    public int getOblivion() {
        return this.oblivion;
    }

    public String getHashingForBlocks() {
        return this.hashingForBlocks;
    }

    public String getHashingForTransactions() {
        return this.hashingForTransactions;
    }

    public String getHashingForDeadlines() {
        return this.hashingForDeadlines;
    }

    public String getHashingForGenerations() {
        return this.hashingForGenerations;
    }

    public String getSignatureForBlocks() {
        return this.signatureForBlocks;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public BlockDescription unmap() throws NoSuchAlgorithmException, InconsistentJsonException {
        return AbstractBlockDescription.from(this);
    }
}

