/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.Peers;
import io.mokamint.node.api.Peer;
import io.mokamint.node.api.PeerInfo;
import io.mokamint.node.internal.gson.PeerInfoJson;
import java.util.Objects;

public class PeerInfoImpl
implements PeerInfo {
    private final Peer peer;
    private final long points;
    private final boolean connected;

    public PeerInfoImpl(Peer peer, long points, boolean connected) {
        if (points <= 0L) {
            throw new IllegalArgumentException("points must be positive");
        }
        this.peer = Objects.requireNonNull(peer);
        this.points = points;
        this.connected = connected;
    }

    public PeerInfoImpl(PeerInfoJson json) throws InconsistentJsonException {
        long points = json.getPoints();
        if (points <= 0L) {
            throw new InconsistentJsonException("points must be positive");
        }
        Peers.Json peer = json.getPeer();
        if (peer == null) {
            throw new InconsistentJsonException("peer cannot be null");
        }
        this.peer = peer.unmap();
        this.points = points;
        this.connected = json.isConnected();
    }

    public Peer getPeer() {
        return this.peer;
    }

    public long getPoints() {
        return this.points;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean equals(Object other) {
        PeerInfo info;
        return other instanceof PeerInfo && this.peer.equals((Object)(info = (PeerInfo)other).getPeer()) && this.points == info.getPoints() && this.connected == info.isConnected();
    }

    public int hashCode() {
        return this.peer.hashCode() ^ Long.hashCode(this.points);
    }

    public int compareTo(PeerInfo other) {
        int diff = -Boolean.compare(this.connected, other.isConnected());
        if (diff != 0) {
            return diff;
        }
        diff = -Long.compare(this.points, other.getPoints());
        if (diff != 0) {
            return diff;
        }
        return this.peer.compareTo((Object)other.getPeer());
    }

    public String toString() {
        return String.valueOf(this.peer) + ", points = " + this.points + ", connected: " + this.connected;
    }
}

