/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.MempoolEntries;
import io.mokamint.node.api.MempoolEntry;
import io.mokamint.node.api.MempoolPortion;
import io.mokamint.node.internal.gson.MempoolPortionJson;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MempoolPortionImpl
implements MempoolPortion {
    private final MempoolEntry[] entries;

    public MempoolPortionImpl(Stream<MempoolEntry> entries) {
        this.entries = (MempoolEntry[])entries.map(Objects::requireNonNull).toArray(MempoolEntry[]::new);
    }

    public MempoolPortionImpl(MempoolPortionJson json) throws InconsistentJsonException {
        MempoolEntries.Json[] entriesAsArray = (MempoolEntries.Json[])json.getEntries().toArray(MempoolEntries.Json[]::new);
        this.entries = new MempoolEntry[entriesAsArray.length];
        int pos = 0;
        for (MempoolEntries.Json entry : entriesAsArray) {
            if (entry == null) {
                throw new InconsistentJsonException("entries cannot contain a null element");
            }
            this.entries[pos++] = entry.unmap();
        }
    }

    public Stream<MempoolEntry> getEntries() {
        return Stream.of(this.entries);
    }

    public boolean equals(Object other) {
        MempoolPortion mpp;
        if (other instanceof MempoolPortionImpl) {
            MempoolPortionImpl mpi = (MempoolPortionImpl)other;
            return Arrays.deepEquals(this.entries, mpi.entries);
        }
        return other instanceof MempoolPortion && Arrays.deepEquals(this.entries, (mpp = (MempoolPortion)other).getEntries().toArray(MempoolEntry[]::new));
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    public String toString() {
        return this.getEntries().map(MempoolEntry::toString).collect(Collectors.joining("\n"));
    }
}

