/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.mokamint.node.api.Memory;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Stream;

public class MemoryImpl<T>
implements Memory<T> {
    private final long size;
    private final Object lock = new Object();
    private final Set<T> seen = new HashSet<T>();
    private final Deque<T> elements = new LinkedList<T>();

    public MemoryImpl(int maximalSize) {
        if (maximalSize < 0) {
            throw new IllegalArgumentException("maximalSize cannot be negative");
        }
        this.size = maximalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T element) {
        Object object = this.lock;
        synchronized (object) {
            boolean reachedMax;
            boolean bl = reachedMax = (long)this.seen.size() == this.size;
            if (this.seen.add(element)) {
                this.elements.add(element);
                if (reachedMax) {
                    this.seen.remove(this.elements.removeFirst());
                }
                return this.size > 0L;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T element) {
        Object object = this.lock;
        synchronized (object) {
            if (this.seen.remove(element)) {
                this.elements.remove(element);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> stream() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedList<T>(this.elements).stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.elements.size();
        }
    }
}

