/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.ChainPortion;
import io.mokamint.node.internal.gson.ChainPortionJson;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChainPortionImpl
implements ChainPortion {
    private final byte[][] hashes;

    public ChainPortionImpl(Stream<byte[]> hashes) {
        this.hashes = (byte[][])hashes.map(rec$ -> (byte[])((byte[])rec$).clone()).toArray(x$0 -> new byte[x$0][]);
    }

    public ChainPortionImpl(ChainPortionJson json) throws InconsistentJsonException {
        String[] hashes = (String[])json.getHashes().toArray(String[]::new);
        this.hashes = new byte[hashes.length][];
        for (int pos = 0; pos < hashes.length; ++pos) {
            String hash = hashes[pos];
            if (hash == null) {
                throw new InconsistentJsonException("hashes cannot contain a null element");
            }
            try {
                this.hashes[pos] = Hex.fromHexString((String)hashes[pos]);
                continue;
            }
            catch (HexConversionException e) {
                throw new InconsistentJsonException((Throwable)e);
            }
        }
    }

    public Stream<byte[]> getHashes() {
        return Stream.of(this.hashes).map(rec$ -> (byte[])((byte[])rec$).clone());
    }

    public boolean equals(Object other) {
        ChainPortion ocp;
        if (other instanceof ChainPortionImpl) {
            ChainPortionImpl cpi = (ChainPortionImpl)other;
            return Arrays.deepEquals((Object[])this.hashes, (Object[])cpi.hashes);
        }
        return other instanceof ChainPortion && Arrays.deepEquals((Object[])this.hashes, (ocp = (ChainPortion)other).getHashes().toArray(x$0 -> new byte[x$0][]));
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.hashes);
    }

    public String toString() {
        return Stream.of(this.hashes).map(Hex::toHexString).collect(Collectors.joining("\n"));
    }
}

