/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.api.ChainInfo;
import io.mokamint.node.internal.gson.ChainInfoJson;
import java.util.Arrays;
import java.util.Optional;

public class ChainInfoImpl
implements ChainInfo {
    private final long length;
    private final Optional<byte[]> genesisHash;
    private final Optional<byte[]> headHash;
    private final Optional<byte[]> headStateId;

    public ChainInfoImpl(long length, Optional<byte[]> genesisHash, Optional<byte[]> headHash, Optional<byte[]> headStateId) {
        if (length < 0L) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (length == 0L) {
            if (genesisHash.isPresent() || headHash.isPresent()) {
                throw new IllegalArgumentException("An empty chain cannot have a genesis nor a head block");
            }
        } else if (genesisHash.isEmpty() || headHash.isEmpty()) {
            throw new IllegalArgumentException("A non-empty chain must have both a genesis and a head block");
        }
        this.length = length;
        this.genesisHash = genesisHash.map(rec$ -> (byte[])((byte[])rec$).clone());
        this.headHash = headHash.map(rec$ -> (byte[])((byte[])rec$).clone());
        this.headStateId = headStateId.map(rec$ -> (byte[])((byte[])rec$).clone());
    }

    public ChainInfoImpl(ChainInfoJson json) throws InconsistentJsonException {
        long length = json.getLength();
        String genesisHash = json.getGenesisHash();
        String headHash = json.getHeadHash();
        String headStateId = json.getHeadStateId();
        if (length < 0L) {
            throw new InconsistentJsonException("length cannot be negative");
        }
        if (length == 0L) {
            if (genesisHash != null || headHash != null) {
                throw new InconsistentJsonException("An empty chain cannot have a genesis nor a head block");
            }
        } else if (genesisHash == null || headHash == null) {
            throw new InconsistentJsonException("A non-empty chain must have both a genesis and a head block");
        }
        this.length = length;
        try {
            this.genesisHash = genesisHash == null ? Optional.empty() : Optional.of(Hex.fromHexString((String)genesisHash));
            this.headHash = headHash == null ? Optional.empty() : Optional.of(Hex.fromHexString((String)headHash));
            this.headStateId = headStateId == null ? Optional.empty() : Optional.of(Hex.fromHexString((String)headStateId));
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public long getLength() {
        return this.length;
    }

    public Optional<byte[]> getGenesisHash() {
        return this.genesisHash.map(rec$ -> (byte[])((byte[])rec$).clone());
    }

    public Optional<byte[]> getHeadHash() {
        return this.headHash.map(rec$ -> (byte[])((byte[])rec$).clone());
    }

    public Optional<byte[]> getHeadStateId() {
        return this.headStateId.map(rec$ -> (byte[])((byte[])rec$).clone());
    }

    public boolean equals(Object other) {
        ChainInfo ci;
        if (other instanceof ChainInfoImpl) {
            ChainInfoImpl cii = (ChainInfoImpl)other;
            return this.length == cii.length && ChainInfoImpl.same(this.genesisHash, cii.genesisHash) && ChainInfoImpl.same(this.headHash, cii.headHash) && ChainInfoImpl.same(this.headStateId, cii.headStateId);
        }
        return other instanceof ChainInfo && this.length == (ci = (ChainInfo)other).getLength() && ChainInfoImpl.same(this.genesisHash, ci.getGenesisHash()) && ChainInfoImpl.same(this.headHash, ci.getHeadHash()) && ChainInfoImpl.same(this.headStateId, ci.getHeadStateId());
    }

    public int hashCode() {
        return this.headHash.or(() -> this.genesisHash).map(Arrays::hashCode).orElse(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("* height: " + this.length + "\n");
        builder.append("* hash of the genesis block: " + ChainInfoImpl.toString(this.genesisHash) + "\n");
        builder.append("* hash of the head block: " + ChainInfoImpl.toString(this.headHash) + "\n");
        builder.append("* state id of the head block: " + ChainInfoImpl.toString(this.headStateId));
        return builder.toString();
    }

    private static boolean same(Optional<byte[]> hash1, Optional<byte[]> hash2) {
        return hash1.isEmpty() == hash2.isEmpty() && (hash1.isEmpty() || Arrays.equals(hash1.get(), hash2.get()));
    }

    private static String toString(Optional<byte[]> hash) {
        return hash.isEmpty() ? "--" : Hex.toHexString((byte[])hash.get());
    }
}

