/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.Versions;
import io.mokamint.node.api.NodeInfo;
import io.mokamint.node.api.Version;
import io.mokamint.node.internal.gson.NodeInfoJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.UUID;

public class NodeInfoImpl
implements NodeInfo {
    private final Version version;
    private final UUID uuid;
    private final LocalDateTime localDateTimeUTC;

    public NodeInfoImpl(Version version, UUID uuid, LocalDateTime localDateTimeUTC) {
        this.version = Objects.requireNonNull(version);
        this.uuid = Objects.requireNonNull(uuid);
        this.localDateTimeUTC = Objects.requireNonNull(localDateTimeUTC);
    }

    public NodeInfoImpl(NodeInfoJson json) throws InconsistentJsonException {
        Versions.Json version = json.getVersion();
        if (version == null) {
            throw new InconsistentJsonException("version cannot be null");
        }
        this.version = version.unmap();
        String uuid = json.getUuid();
        if (uuid == null) {
            throw new InconsistentJsonException("uuid cannot be null");
        }
        try {
            this.uuid = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        String localDateTimeUTC = json.getLocalDateTimeUTC();
        if (localDateTimeUTC == null) {
            throw new InconsistentJsonException("localDateTimeUTC cannot be null");
        }
        try {
            this.localDateTimeUTC = LocalDateTime.parse(localDateTimeUTC, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public LocalDateTime getLocalDateTimeUTC() {
        return this.localDateTimeUTC;
    }

    public boolean equals(Object other) {
        NodeInfo ni;
        return other instanceof NodeInfo && this.uuid.equals((ni = (NodeInfo)other).getUUID()) && this.version.equals((Object)ni.getVersion()) && this.localDateTimeUTC.equals(ni.getLocalDateTimeUTC());
    }

    public int hashCode() {
        return this.uuid.hashCode() ^ this.localDateTimeUTC.hashCode();
    }

    public String toString() {
        return "version: " + String.valueOf(this.version) + ", UUID: " + String.valueOf(this.uuid) + ", UTC date and time: " + String.valueOf(this.localDateTimeUTC);
    }
}

