/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.Marshallable;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.node.BlockDescriptions;
import io.mokamint.node.api.Block;
import io.mokamint.node.api.BlockDescription;
import io.mokamint.node.api.ConsensusConfig;
import io.mokamint.node.api.GenesisBlockDescription;
import io.mokamint.node.api.NonGenesisBlockDescription;
import io.mokamint.node.internal.AbstractBlockDescription;
import io.mokamint.node.internal.GenesisBlockImpl;
import io.mokamint.node.internal.NonGenesisBlockImpl;
import io.mokamint.node.internal.gson.BlockJson;
import io.mokamint.nonce.api.Deadline;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.function.Function;

public abstract sealed class AbstractBlock<D extends BlockDescription, B extends AbstractBlock<D, B>>
extends AbstractMarshallable
implements Block
permits GenesisBlockImpl, NonGenesisBlockImpl {
    private final D description;
    private final byte[] stateId;
    private final byte[] signature;
    private final Object lock = new Object();
    private byte[] lastHash;
    private static final BigInteger _100000 = BigInteger.valueOf(100000L);

    protected AbstractBlock(D description, BlockJson json) throws InconsistentJsonException {
        this.description = description;
        this.stateId = Hex.fromHexString((String)((String)Objects.requireNonNull((Object)json.getStateId(), (String)"stateId cannot be null", InconsistentJsonException::new)), InconsistentJsonException::new);
        this.signature = Hex.fromHexString((String)((String)Objects.requireNonNull((Object)json.getSignature(), (String)"signature cannot be null", InconsistentJsonException::new)), InconsistentJsonException::new);
    }

    protected AbstractBlock(D description, byte[] stateId, PrivateKey privateKey, Function<B, byte[]> marshaller) throws InvalidKeyException, SignatureException {
        this.description = (BlockDescription)Objects.requireNonNull(description, (String)"description cannot be null", NullPointerException::new);
        this.stateId = (byte[])((byte[])Objects.requireNonNull((Object)stateId, (String)"stateId cannot be null", NullPointerException::new)).clone();
        this.signature = description.getSignatureForBlocks().getSigner(privateKey, Function.identity()).sign((Object)marshaller.apply(this.getThis()));
    }

    protected AbstractBlock(D description, UnmarshallingContext context) throws IOException {
        this.description = description;
        this.stateId = context.readLengthAndBytes("State id length mismatch");
        OptionalInt maybeLength = description.getSignatureForBlocks().length();
        this.signature = maybeLength.isPresent() ? context.readBytes(maybeLength.getAsInt(), "Signature length mismatch") : context.readLengthAndBytes("Signature length mismatch");
    }

    public boolean signatureIsValid() throws InvalidKeyException, SignatureException {
        return this.description.getSignatureForBlocks().getVerifier(this.description.getPublicKeyForSigningBlock(), Function.identity()).verify((Object)this.toByteArrayWithoutSignature(), this.signature);
    }

    public static Block from(UnmarshallingContext context, ConsensusConfig<?, ?> config) throws IOException {
        BlockDescription description = AbstractBlockDescription.from(context, config);
        if (description instanceof GenesisBlockDescription) {
            GenesisBlockDescription gbd = (GenesisBlockDescription)description;
            return new GenesisBlockImpl(gbd, context);
        }
        return new NonGenesisBlockImpl((NonGenesisBlockDescription)description, context);
    }

    public static Block from(UnmarshallingContext context) throws IOException, NoSuchAlgorithmException {
        BlockDescription description = AbstractBlockDescription.from(context);
        if (description instanceof GenesisBlockDescription) {
            GenesisBlockDescription gbd = (GenesisBlockDescription)description;
            return new GenesisBlockImpl(gbd, context);
        }
        return new NonGenesisBlockImpl((NonGenesisBlockDescription)description, context);
    }

    public static Block from(BlockJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
        BlockDescriptions.Json descriptionJson = json.getDescription();
        if (descriptionJson == null) {
            throw new InconsistentJsonException("description cannot be null");
        }
        BlockDescription description = descriptionJson.unmap();
        if (description instanceof GenesisBlockDescription) {
            GenesisBlockDescription gbd = (GenesisBlockDescription)description;
            return new GenesisBlockImpl(gbd, json);
        }
        return new NonGenesisBlockImpl((NonGenesisBlockDescription)description, json);
    }

    public final D getDescription() {
        return this.description;
    }

    public final byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public final byte[] getStateId() {
        return (byte[])this.stateId.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getHash() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastHash != null) {
                return (byte[])this.lastHash.clone();
            }
        }
        byte[] result = this.description.getHashingForBlocks().getHasher(Marshallable::toByteArray).hash((Object)this);
        Object object2 = this.lock;
        synchronized (object2) {
            this.lastHash = (byte[])result.clone();
        }
        return result;
    }

    public final String getHexHash() {
        return Hex.toHexString((byte[])this.getHash());
    }

    public final NonGenesisBlockDescription getNextBlockDescription(Deadline deadline) {
        long heightForNewBlock = this.description.getHeight() + 1L;
        BigInteger powerForNewBlock = this.computePower(deadline);
        long waitingTimeForNewBlock = deadline.getMillisecondsToWait(this.description.getAcceleration());
        long weightedWaitingTimeForNewBlock = this.computeWeightedWaitingTime(waitingTimeForNewBlock);
        long totalWaitingTimeForNewBlock = this.computeTotalWaitingTime(waitingTimeForNewBlock);
        BigInteger accelerationForNewBlock = this.computeAcceleration(weightedWaitingTimeForNewBlock);
        byte[] hashOfPreviousBlock = this.getHash();
        return BlockDescriptions.of(heightForNewBlock, powerForNewBlock, totalWaitingTimeForNewBlock, weightedWaitingTimeForNewBlock, accelerationForNewBlock, deadline, hashOfPreviousBlock, this.description.getTargetBlockCreationTime(), this.description.getOblivion(), this.description.getHashingForBlocks(), this.description.getHashingForTransactions());
    }

    public boolean equals(Object other) {
        Block block;
        if (other instanceof Block && this.description.equals((Object)(block = (Block)other).getDescription())) {
            if (other instanceof AbstractBlock) {
                AbstractBlock oab = (AbstractBlock)((Object)other);
                return Arrays.equals(this.signature, oab.signature) && Arrays.equals(this.stateId, oab.stateId);
            }
            return Arrays.equals(this.signature, block.getSignature()) && Arrays.equals(this.stateId, block.getStateId());
        }
        return false;
    }

    public int hashCode() {
        return this.description.hashCode() ^ Arrays.hashCode(this.stateId);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.populate(builder);
        return builder.toString();
    }

    public void into(MarshallingContext context) throws IOException {
        this.description.into(context);
        context.writeLengthAndBytes(this.stateId);
        this.writeSignature(context);
    }

    public void intoWithoutConfigurationData(MarshallingContext context) throws IOException {
        this.description.intoWithoutConfigurationData(context);
        context.writeLengthAndBytes(this.stateId);
        this.writeSignature(context);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final byte[] toByteArrayWithoutConfigurationData() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                MarshallingContext context = this.createMarshallingContext(baos);
                try {
                    this.intoWithoutConfigurationData(context);
                    context.flush();
                    byArray = baos.toByteArray();
                    if (context == null) break block13;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected final byte[] toByteArrayWithoutSignature() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                MarshallingContext context = this.createMarshallingContext(baos);
                try {
                    this.intoWithoutSignature(context);
                    context.flush();
                    byArray = baos.toByteArray();
                    if (context == null) break block13;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                context.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    protected void populate(StringBuilder builder) {
        builder.append("* hash: " + this.getHexHash() + " (" + String.valueOf(this.description.getHashingForBlocks()) + ")\n");
        builder.append(this.description);
        builder.append("\n");
        builder.append("* node's signature: " + Hex.toHexString((byte[])this.signature) + " (" + String.valueOf(this.description.getSignatureForBlocks()) + ")\n");
        builder.append("* final state id: " + Hex.toHexString((byte[])this.stateId));
    }

    protected void intoWithoutSignature(MarshallingContext context) throws IOException {
        this.description.into(context);
        context.writeLengthAndBytes(this.stateId);
    }

    protected abstract B getThis();

    private void writeSignature(MarshallingContext context) throws IOException {
        OptionalInt maybeLength = this.description.getSignatureForBlocks().length();
        if (maybeLength.isPresent()) {
            context.writeBytes(this.signature);
        } else {
            context.writeLengthAndBytes(this.signature);
        }
    }

    private BigInteger computePower(Deadline deadline) {
        return this.description.getPower().add(deadline.getPower());
    }

    private long computeTotalWaitingTime(long waitingTime) {
        return this.description.getTotalWaitingTime() + waitingTime;
    }

    private long computeWeightedWaitingTime(long waitingTime) {
        BigInteger complementOfOblivion = BigInteger.valueOf(100000 - this.description.getOblivion());
        BigInteger previousWeightedWaitingTimeWeighted = BigInteger.valueOf(this.description.getWeightedWaitingTime()).multiply(complementOfOblivion);
        BigInteger waitingTimeWeighted = BigInteger.valueOf(waitingTime).multiply(BigInteger.valueOf(this.description.getOblivion()));
        return previousWeightedWaitingTimeWeighted.add(waitingTimeWeighted).divide(_100000).longValue();
    }

    private BigInteger computeAcceleration(long weightedWaitingTimeForNewBlock) {
        BigInteger delta;
        BigInteger oldAcceleration = this.description.getAcceleration();
        BigInteger acceleration = oldAcceleration.add((delta = oldAcceleration.multiply(BigInteger.valueOf(weightedWaitingTimeForNewBlock)).divide(BigInteger.valueOf(this.description.getTargetBlockCreationTime())).subtract(oldAcceleration)).multiply(BigInteger.valueOf(this.description.getOblivion())).divide(_100000));
        return acceleration.signum() == 0 ? BigInteger.ONE : acceleration;
    }
}

