/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.mokamint.node.api.NonGenesisBlock;
import io.mokamint.node.internal.AbstractBlock;
import io.mokamint.nonce.Deadlines;
import io.mokamint.nonce.api.Deadline;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;

public class NonGenesisBlockImpl
extends AbstractBlock
implements NonGenesisBlock {
    private final long height;
    private final long totalWaitingTime;
    private final long weightedWaitingTime;
    private final BigInteger acceleration;
    private final Deadline deadline;
    private final byte[] hashOfPreviousBlock;

    public NonGenesisBlockImpl(long height, long totalWaitingTime, long weightedWaitingTime, BigInteger acceleration, Deadline deadline, byte[] hashOfPreviousBlock) {
        this.height = height;
        this.totalWaitingTime = totalWaitingTime;
        this.weightedWaitingTime = weightedWaitingTime;
        this.acceleration = acceleration;
        this.deadline = deadline;
        this.hashOfPreviousBlock = hashOfPreviousBlock;
    }

    NonGenesisBlockImpl(long height, UnmarshallingContext context) throws NoSuchAlgorithmException, IOException {
        this.height = height;
        this.totalWaitingTime = context.readLong();
        this.weightedWaitingTime = context.readLong();
        this.acceleration = context.readBigInteger();
        this.deadline = Deadlines.from((UnmarshallingContext)context);
        int hashOfPreviousBlockLength = context.readCompactInt();
        this.hashOfPreviousBlock = context.readBytes(hashOfPreviousBlockLength, "previous block hash length mismatch");
    }

    public long getTotalWaitingTime() {
        return this.totalWaitingTime;
    }

    public long getWeightedWaitingTime() {
        return this.weightedWaitingTime;
    }

    public BigInteger getAcceleration() {
        return this.acceleration;
    }

    public long getHeight() {
        return this.height;
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public byte[] getHashOfPreviousBlock() {
        return this.hashOfPreviousBlock;
    }

    @Override
    public byte[] getNextGenerationSignature(HashingAlgorithm<byte[]> hashing) {
        byte[] previousGenerationSignature = this.deadline.getData();
        byte[] previousProlog = this.deadline.getProlog();
        return hashing.hash((Object)NonGenesisBlockImpl.concat(previousGenerationSignature, previousProlog));
    }

    public void into(MarshallingContext context) throws IOException {
        context.writeLong(this.height);
        context.writeLong(this.totalWaitingTime);
        context.writeLong(this.weightedWaitingTime);
        context.writeBigInteger(this.acceleration);
        this.deadline.into(context);
        context.writeCompactInt(this.hashOfPreviousBlock.length);
        context.write(this.hashOfPreviousBlock);
    }
}

