/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.api.MarshallingContext;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.mokamint.node.api.GenesisBlock;
import io.mokamint.node.internal.AbstractBlock;
import java.io.IOException;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class GenesisBlockImpl
extends AbstractBlock
implements GenesisBlock {
    private final LocalDateTime startDateTimeUTC;
    private static final byte[] BLOCK_1_GENERATION_SIGNATURE = new byte[]{13, 1, 19, 73};

    public GenesisBlockImpl(LocalDateTime startDateTimeUTC) {
        this.startDateTimeUTC = startDateTimeUTC;
    }

    GenesisBlockImpl(UnmarshallingContext context) throws IOException {
        String startDateTimeUTC = context.readUTF();
        this.startDateTimeUTC = LocalDateTime.parse(startDateTimeUTC, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LocalDateTime getStartDateTimeUTC() {
        return this.startDateTimeUTC;
    }

    public long getTotalWaitingTime() {
        return 0L;
    }

    public long getWeightedWaitingTime() {
        return 0L;
    }

    public BigInteger getAcceleration() {
        return BigInteger.valueOf(100000000000L);
    }

    public long getHeight() {
        return 0L;
    }

    @Override
    protected byte[] getNextGenerationSignature(HashingAlgorithm<byte[]> hashing) {
        return BLOCK_1_GENERATION_SIGNATURE;
    }

    public void into(MarshallingContext context) throws IOException {
        context.writeLong(0L);
        context.writeUTF(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.startDateTimeUTC));
    }
}

