/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.node.internal;

import io.hotmoka.crypto.api.HashingAlgorithm;
import io.hotmoka.marshalling.AbstractMarshallable;
import io.hotmoka.marshalling.api.UnmarshallingContext;
import io.mokamint.node.api.Block;
import io.mokamint.node.internal.GenesisBlockImpl;
import io.mokamint.node.internal.NonGenesisBlockImpl;
import io.mokamint.nonce.DeadlineDescriptions;
import io.mokamint.nonce.api.DeadlineDescription;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;

public abstract class AbstractBlock
extends AbstractMarshallable
implements Block {
    private static final BigInteger SCOOPS_PER_NONCE = BigInteger.valueOf(4096L);

    public static AbstractBlock from(UnmarshallingContext context) throws NoSuchAlgorithmException, IOException {
        long height = context.readLong();
        if (height == 0L) {
            return new GenesisBlockImpl(context);
        }
        if (height > 0L) {
            return new NonGenesisBlockImpl(height, context);
        }
        throw new IOException("negative block height");
    }

    public final DeadlineDescription getNextDeadlineDescription(HashingAlgorithm<byte[]> hashingForGenerations, HashingAlgorithm<byte[]> hashingForDeadlines) {
        byte[] nextGenerationSignature = this.getNextGenerationSignature(hashingForGenerations);
        return DeadlineDescriptions.of((int)this.getNextScoopNumber(nextGenerationSignature, hashingForGenerations), (byte[])nextGenerationSignature, hashingForDeadlines);
    }

    private int getNextScoopNumber(byte[] nextGenerationSignature, HashingAlgorithm<byte[]> hashing) {
        byte[] generationHash = hashing.hash((Object)AbstractBlock.concat(nextGenerationSignature, AbstractBlock.longToBytesBE(this.getHeight() + 1L)));
        return new BigInteger(1, generationHash).remainder(SCOOPS_PER_NONCE).intValue();
    }

    protected abstract byte[] getNextGenerationSignature(HashingAlgorithm<byte[]> var1);

    protected static byte[] concat(byte[] array1, byte[] array2) {
        byte[] merge = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, merge, 0, array1.length);
        System.arraycopy(array2, 0, merge, array1.length, array2.length);
        return merge;
    }

    private static byte[] longToBytesBE(long l) {
        byte[] target = new byte[8];
        for (int i = 0; i <= 7; ++i) {
            target[7 - i] = (byte)(l >> 8 * i & 0xFFL);
        }
        return target;
    }
}

