/*
Copyright 2023 Fausto Spoto

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package io.mokamint.miner.cli.internal;

import io.hotmoka.crypto.cli.keys.Create;
import io.hotmoka.crypto.cli.keys.Export;
import io.hotmoka.crypto.cli.keys.Import;
import io.hotmoka.crypto.cli.keys.Show;
import picocli.CommandLine.Command;
import picocli.CommandLine.HelpCommand;

@Command(name = "keys",
	description = "Manage cryptographic keys.",
	subcommands = {
		Create.class,
		Export.class,
		HelpCommand.class,
		Import.class,
		Show.class
	})
public class Keys {
}