/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.cli.internal;

import io.hotmoka.cli.AbstractCommand;
import io.hotmoka.cli.CommandException;
import io.hotmoka.websockets.api.FailedDeploymentException;
import io.mokamint.miner.api.Miner;
import io.mokamint.miner.local.LocalMiners;
import io.mokamint.miner.local.api.LocalMiner;
import io.mokamint.miner.service.MinerServices;
import io.mokamint.miner.service.api.MinerService;
import io.mokamint.plotter.Plots;
import io.mokamint.plotter.api.Plot;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start a new miner service."}, showDefaultValues=true)
public class Start
extends AbstractCommand {
    @CommandLine.Parameters(index="0", description={"the paths of the plots used for mining"})
    private Path[] plots;
    @CommandLine.Option(names={"--uri"}, description={"the URI of the remote mining endpoint"}, defaultValue="ws://localhost:8025")
    private URI uri;
    private static final Logger LOGGER = Logger.getLogger(Start.class.getName());

    protected void execute() throws CommandException {
        new Run();
    }

    private class Run {
        private final List<Plot> plots = new ArrayList<Plot>();

        private Run() throws CommandException {
            this.loadPlotsAndStartMiningService(0);
        }

        private void loadPlotsAndStartMiningService(int pos) throws CommandException {
            if (Start.this.plots == null) {
                throw new CommandException("At least one plot file must be specified!");
            }
            if (pos < Start.this.plots.length) {
                Path pathOfPlot = Start.this.plots[pos];
                System.out.print("Loading " + String.valueOf(pathOfPlot) + "... ");
                try (Plot plot = Plots.load((Path)pathOfPlot);){
                    System.out.println(CommandLine.Help.Ansi.AUTO.string("@|blue done.|@"));
                    this.plots.add(plot);
                    this.loadPlotsAndStartMiningService(pos + 1);
                }
                catch (IOException e) {
                    System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red I/O error while accessing plot file " + String.valueOf(pathOfPlot) + "! " + e.getMessage() + "|@"));
                    LOGGER.warning("I/O error while acccessing plot file \"" + String.valueOf(pathOfPlot) + "\" and its key pair: " + e.getMessage());
                    this.loadPlotsAndStartMiningService(pos + 1);
                }
                catch (NoSuchAlgorithmException e) {
                    System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red failed since the plot file " + String.valueOf(pathOfPlot) + " uses an unknown hashing algorithm!|@"));
                    LOGGER.warning("the plot file \"" + String.valueOf(pathOfPlot) + "\" uses an unknown hashing algorithm: " + e.getMessage());
                    this.loadPlotsAndStartMiningService(pos + 1);
                }
            } else {
                if (this.plots.isEmpty()) {
                    throw new CommandException("No plot file have been loaded!");
                }
                try (LocalMiner miner = LocalMiners.of((String)"Internal miner", (String)("A miner working for " + String.valueOf(Start.this.uri)), (_signature, _publicKey) -> Optional.empty(), (Plot[])((Plot[])this.plots.toArray(Plot[]::new)));){
                    this.startMiningService((Miner)miner);
                }
            }
        }

        private void startMiningService(Miner miner) throws CommandException {
            System.out.print("Connecting to " + String.valueOf(Start.this.uri) + "... ");
            try (MinerService service = MinerServices.of((Miner)miner, (URI)Start.this.uri, (int)30000);){
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|blue done.|@"));
                new Thread(() -> this.closeServiceIfKeyPressed(service)).start();
                System.out.println("Service terminated: " + service.waitUntilClosed());
            }
            catch (FailedDeploymentException e) {
                throw new CommandException("Failed to deploy the miner. Is " + String.valueOf(Start.this.uri) + " up and reachable?", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommandException("Interrupted!", (Throwable)e);
            }
        }

        private void closeServiceIfKeyPressed(MinerService service) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                System.out.print(CommandLine.Help.Ansi.AUTO.string("@|green Press ENTER to stop the miner: |@"));
                reader.readLine();
            }
            catch (IOException e) {
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red Cannot access the standard input!|@"));
                LOGGER.log(Level.WARNING, "cannot access the standard input", e);
            }
            service.close();
        }
    }
}

