/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.cli.internal;

import io.hotmoka.cli.AbstractRpcCommand;
import io.hotmoka.cli.CommandException;
import io.mokamint.miner.MiningSpecifications;
import io.mokamint.miner.api.ClosedMinerException;
import io.mokamint.miner.api.MiningSpecification;
import io.mokamint.miner.service.MinerServices;
import io.mokamint.miner.service.api.MinerService;
import jakarta.websocket.EncodeException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show the specification of a remote miner."}, showDefaultValues=true)
public class Info
extends AbstractRpcCommand<MinerService> {
    @CommandLine.Option(names={"--uri"}, description={"the network URI where the API of the remote miner is published"}, defaultValue="ws://localhost:8025")
    private URI uri;
    @CommandLine.Option(names={"--redirection"}, paramLabel="<path>", description={"the path where the output must be redirected, if any; if missing, the output is printed to the standard output"})
    private Path redirection;
    @CommandLine.Option(names={"--json"}, description={"print the output in JSON"}, defaultValue="false")
    private boolean json;

    protected Info() {
    }

    protected void execute() throws CommandException {
        this.execute(MinerServices::of, this::body, this.uri);
    }

    private void body(MinerService service) throws TimeoutException, InterruptedException, CommandException {
        block9: {
            try {
                String result;
                MiningSpecification miningSpecification = service.getMiningSpecification();
                if (this.json) {
                    try {
                        result = new MiningSpecifications.Encoder().encode((Object)miningSpecification) + "\n";
                    }
                    catch (EncodeException e) {
                        throw new CommandException("Could not encode the mining specification in JSON format: " + e.getMessage());
                    }
                } else {
                    result = miningSpecification.toString() + "\n";
                }
                if (this.redirection == null) {
                    System.out.print(result);
                    break block9;
                }
                try {
                    Files.writeString(this.redirection, (CharSequence)result, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new CommandException("Could not write the output into \"" + String.valueOf(this.redirection) + "\": " + e.getMessage());
                }
            }
            catch (ClosedMinerException e) {
                throw new CommandException("The mining remote has been closed: " + e.getMessage());
            }
        }
    }
}

