/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.cli.internal;

import com.google.gson.Gson;
import io.hotmoka.cli.AbstractRpcCommand;
import io.hotmoka.cli.CommandException;
import io.hotmoka.crypto.Base58;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.mokamint.miner.api.ClosedMinerException;
import io.mokamint.miner.cli.internal.SignatureOptionConverter;
import io.mokamint.miner.service.MinerServices;
import io.mokamint.miner.service.api.MinerService;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

@CommandLine.Command(name="balance", description={"Show the balance of a public key in a remote miner."}, showDefaultValues=true)
public class Balance
extends AbstractRpcCommand<MinerService> {
    @CommandLine.Parameters(index="0", description={"the Base58-encoded public key whose balance is required"})
    private String publicKeyBase58;
    @CommandLine.Option(names={"--signature"}, description={"the signature algorithm for the public key (ed25519, sha256dsa, qtesla1, qtesla3)"}, converter={SignatureOptionConverter.class}, defaultValue="ed25519")
    private SignatureAlgorithm signature;
    @CommandLine.Option(names={"--uri"}, description={"the network URI where the API of the remote miner is published"}, defaultValue="ws://localhost:8025")
    private URI uri;
    @CommandLine.Option(names={"--redirection"}, paramLabel="<path>", description={"the path where the output must be redirected, if any; if missing, the output is printed to the standard output"})
    private Path redirection;
    @CommandLine.Option(names={"--json"}, description={"print the output in JSON"}, defaultValue="false")
    private boolean json;

    protected Balance() {
    }

    protected void execute() throws CommandException {
        this.execute(MinerServices::of, this::body, this.uri);
    }

    private void body(MinerService service) throws TimeoutException, InterruptedException, CommandException {
        block9: {
            PublicKey publicKey;
            try {
                publicKey = this.signature.publicKeyFromEncoding(Base58.fromBase58String((String)this.publicKeyBase58, CommandException::new));
            }
            catch (InvalidKeySpecException e) {
                throw new CommandException("The public key is invalid for signature " + String.valueOf(this.signature));
            }
            try {
                String result;
                Optional maybeBalance = service.getBalance(this.signature, publicKey);
                if (this.json) {
                    Answer answer = new Answer();
                    answer.balance = maybeBalance.orElse(null);
                    result = new Gson().toJsonTree((Object)answer).toString() + "\n";
                } else {
                    result = maybeBalance.map(BigInteger::toString).orElse("not available") + "\n";
                }
                if (this.redirection == null) {
                    System.out.print(result);
                    break block9;
                }
                try {
                    Files.writeString(this.redirection, (CharSequence)result, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new CommandException("Could not write the output into \"" + String.valueOf(this.redirection) + "\": " + e.getMessage());
                }
            }
            catch (ClosedMinerException e) {
                throw new CommandException("The mining remote has been closed: " + e.getMessage());
            }
        }
    }

    private static class Answer {
        private BigInteger balance;

        private Answer() {
        }
    }
}

