/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.cli.internal;

import io.hotmoka.cli.AbstractRpcCommand;
import io.hotmoka.cli.CommandException;
import io.mokamint.miner.MiningSpecifications;
import io.mokamint.miner.api.ClosedMinerException;
import io.mokamint.miner.api.MiningSpecification;
import io.mokamint.miner.service.MinerServices;
import io.mokamint.miner.service.api.MinerService;
import jakarta.websocket.EncodeException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Print the specification of a mining remote."}, showDefaultValues=true)
public class Info
extends AbstractRpcCommand<MinerService> {
    @CommandLine.Option(names={"--uri"}, description={"the network URI where the API of the remote miner is published"}, defaultValue="ws://localhost:8025")
    private URI uri;

    protected Info() {
    }

    protected void execute() throws CommandException {
        this.execute(MinerServices::of, this::body, this.uri);
    }

    private void body(MinerService service) throws TimeoutException, InterruptedException, CommandException {
        block5: {
            try {
                MiningSpecification miningSpecification = service.getMiningSpecification();
                if (this.json()) {
                    try {
                        System.out.println(new MiningSpecifications.Encoder().encode((Object)miningSpecification));
                        break block5;
                    }
                    catch (EncodeException e) {
                        throw new CommandException("Could not encode the mining specification in JSON format: " + e.getMessage());
                    }
                }
                System.out.println(miningSpecification);
            }
            catch (ClosedMinerException e) {
                throw new CommandException("The mining remote has been closed: " + e.getMessage());
            }
        }
    }
}

