/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.miner.cli.internal;

import io.hotmoka.cli.AbstractCommand;
import io.hotmoka.cli.CommandException;
import io.mokamint.miner.api.Miner;
import io.mokamint.miner.local.LocalMiners;
import io.mokamint.miner.service.MinerServices;
import io.mokamint.miner.service.api.MinerService;
import io.mokamint.plotter.AbstractPlotArgs;
import io.mokamint.plotter.api.PlotAndKeyPair;
import jakarta.websocket.DeploymentException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start a new miner service."}, showDefaultValues=true)
public class Start
extends AbstractCommand {
    @CommandLine.ArgGroup(exclusive=false, multiplicity="1..*")
    private PlotArgs[] plotArgs;
    @CommandLine.Option(names={"--uri"}, description={"the URI of the remote mining endpoint"}, defaultValue="ws://localhost:8025")
    private URI uri;
    private static final Logger LOGGER = Logger.getLogger(Start.class.getName());

    protected void execute() throws CommandException {
        new Run();
    }

    private class Run {
        private final List<PlotAndKeyPair> plotsAndKeyPairs = new ArrayList<PlotAndKeyPair>();

        private Run() throws CommandException {
            this.loadPlotsAndStartMiningService(0);
        }

        private void loadPlotsAndStartMiningService(int pos) throws CommandException {
            if (pos < Start.this.plotArgs.length) {
                PlotArgs plotArg = Start.this.plotArgs[pos];
                System.out.print("Loading " + String.valueOf(plotArg.plot) + "... ");
                try (PlotAndKeyPair plotAndKeyPair = plotArg.load();){
                    System.out.println(CommandLine.Help.Ansi.AUTO.string("@|blue done.|@"));
                    this.plotsAndKeyPairs.add(plotAndKeyPair);
                    this.loadPlotsAndStartMiningService(pos + 1);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CommandException("Interrupted while closing a plot!", (Throwable)e);
                }
                catch (IOException e) {
                    System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red I/O error! " + e.getMessage() + "|@"));
                    LOGGER.log(Level.WARNING, "I/O error while acccessing plot file \"" + String.valueOf(plotArg.getPlot()) + "\" and its key pair", e);
                    this.loadPlotsAndStartMiningService(pos + 1);
                }
                catch (NoSuchAlgorithmException e) {
                    System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red failed since the plot file uses an unknown hashing algorithm!|@"));
                    LOGGER.log(Level.WARNING, "the plot file \"" + String.valueOf((Object)plotArg) + "\" uses an unknown hashing algorithm", e);
                    this.loadPlotsAndStartMiningService(pos + 1);
                }
            } else {
                if (this.plotsAndKeyPairs.isEmpty()) {
                    throw new CommandException("No plot file could be loaded!");
                }
                try (Miner miner = LocalMiners.of((PlotAndKeyPair[])((PlotAndKeyPair[])this.plotsAndKeyPairs.toArray(PlotAndKeyPair[]::new)));){
                    this.startMiningService(miner);
                }
                catch (IOException e) {
                    throw new CommandException("Failed to close the local miner", (Throwable)e);
                }
            }
        }

        private void startMiningService(Miner miner) throws CommandException {
            System.out.print("Connecting to " + String.valueOf(Start.this.uri) + "... ");
            try (MinerService service = MinerServices.open((Miner)miner, (URI)Start.this.uri);){
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|blue done.|@"));
                new Thread(() -> this.closeServiceIfKeyPressed(service)).start();
                System.out.println("Service terminated: " + service.waitUntilDisconnected());
            }
            catch (DeploymentException | IOException e) {
                throw new CommandException("Failed to deploy the miner. Is " + String.valueOf(Start.this.uri) + " up and reachable?", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommandException("Interrupted!", (Throwable)e);
            }
        }

        private void closeServiceIfKeyPressed(MinerService service) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                System.out.print(CommandLine.Help.Ansi.AUTO.string("@|green Press ENTER to stop the miner: |@"));
                reader.readLine();
            }
            catch (IOException e) {
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red Cannot access the standard input!|@"));
                LOGGER.log(Level.WARNING, "cannot access the standard input", e);
            }
            try {
                service.close();
            }
            catch (IOException e) {
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|red Cannot close the service!|@"));
                LOGGER.log(Level.WARNING, "cannot close the service", e);
            }
        }
    }

    private static class PlotArgs
    extends AbstractPlotArgs {
        @CommandLine.Parameters(index="0", description={"the file containing a plot"})
        private Path plot;
        @CommandLine.Parameters(index="1", description={"the file containing the key pair of the plot"})
        private Path keyPair;
        @CommandLine.Option(names={"--plot-password"}, description={"the password of the key pair of the plot"}, interactive=true, defaultValue="")
        private char[] password;

        private PlotArgs() {
        }

        public Path getPlot() {
            return this.plot;
        }

        public Path getKeyPair() {
            return this.keyPair;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

