/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Base58;
import io.hotmoka.crypto.SignatureAlgorithms;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.exceptions.ExceptionSupplierFromMessage;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.GetBalanceMessage;
import io.mokamint.application.messages.internal.json.GetBalanceMessageJson;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;

public class GetBalanceMessageImpl
extends AbstractRpcMessage
implements GetBalanceMessage {
    private final SignatureAlgorithm signature;
    private final PublicKey publicKey;
    private final String publicKeyBase58;

    public GetBalanceMessageImpl(SignatureAlgorithm signature, PublicKey publicKey, String id) {
        this(signature, publicKey, id, IllegalArgumentException::new);
    }

    public GetBalanceMessageImpl(GetBalanceMessageJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
        this(SignatureAlgorithms.of((String)((String)Objects.requireNonNull((Object)json.getSignature(), (String)"signature cannot be null", InconsistentJsonException::new))), Base58.fromBase58String((String)((String)Objects.requireNonNull((Object)json.getPublicKey(), (String)"publicKey cannot be null", InconsistentJsonException::new)), InconsistentJsonException::new), json.getId(), InconsistentJsonException::new);
    }

    private <E extends Exception> GetBalanceMessageImpl(SignatureAlgorithm signature, PublicKey publicKey, String id, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        super((String)Objects.requireNonNull((Object)id, (String)"id cannot be null", onIllegalArgs));
        this.signature = (SignatureAlgorithm)Objects.requireNonNull((Object)signature, (String)"signature cannot be null", onIllegalArgs);
        this.publicKey = (PublicKey)Objects.requireNonNull((Object)publicKey, (String)"publicKey cannot be null", onIllegalArgs);
        this.publicKeyBase58 = Base58.toBase58String((byte[])GetBalanceMessageImpl.encodingOf(publicKey, signature, onIllegalArgs));
    }

    private <E extends Exception> GetBalanceMessageImpl(SignatureAlgorithm signature, byte[] publicKey, String id, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        super((String)Objects.requireNonNull((Object)id, (String)"id cannot be null", onIllegalArgs));
        this.signature = (SignatureAlgorithm)Objects.requireNonNull((Object)signature, (String)"signature cannot be null", onIllegalArgs);
        try {
            this.publicKey = signature.publicKeyFromEncoding((byte[])Objects.requireNonNull((Object)publicKey, (String)"publicKey cannot be null", onIllegalArgs));
        }
        catch (InvalidKeySpecException e) {
            throw (Exception)onIllegalArgs.apply((Object)e.getMessage());
        }
        this.publicKeyBase58 = Base58.toBase58String((byte[])publicKey);
    }

    private static <E extends Exception> byte[] encodingOf(PublicKey publicKey, SignatureAlgorithm signature, ExceptionSupplierFromMessage<E> onIllegalArgs) throws E {
        try {
            return signature.encodingOf(publicKey);
        }
        catch (InvalidKeyException e) {
            throw (Exception)onIllegalArgs.apply((Object)e.getMessage());
        }
    }

    public SignatureAlgorithm getSignature() {
        return this.signature;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyBase58() {
        return this.publicKeyBase58;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GetBalanceMessage)) return false;
        GetBalanceMessage gbm = (GetBalanceMessage)other;
        if (!super.equals(other)) return false;
        if (!this.signature.equals((Object)gbm.getSignature())) return false;
        if (!this.publicKey.equals(gbm.getPublicKey())) return false;
        return true;
    }

    protected String getExpectedType() {
        return GetBalanceMessage.class.getName();
    }
}

