/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.exceptions.ExceptionSupplierFromMessage;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.KeepFromMessage;
import io.mokamint.application.messages.internal.json.KeepFromMessageJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class KeepFromMessageImpl
extends AbstractRpcMessage
implements KeepFromMessage {
    private final LocalDateTime start;

    public KeepFromMessageImpl(LocalDateTime start, String id) {
        this(start, id, IllegalArgumentException::new);
    }

    public KeepFromMessageImpl(KeepFromMessageJson json) throws InconsistentJsonException {
        this(KeepFromMessageImpl.parse((String)Objects.requireNonNull((Object)json.getStart(), (String)"start cannot be null", InconsistentJsonException::new)), json.getId(), InconsistentJsonException::new);
    }

    private static LocalDateTime parse(String when) throws InconsistentJsonException {
        try {
            return LocalDateTime.parse(when, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    private <E extends Exception> KeepFromMessageImpl(LocalDateTime start, String id, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        super(id, onIllegalArgs);
        this.start = (LocalDateTime)Objects.requireNonNull((Object)start, (String)"start cannot be null", onIllegalArgs);
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof KeepFromMessage)) return false;
        KeepFromMessage kfm = (KeepFromMessage)other;
        if (!super.equals(other)) return false;
        if (!this.start.equals(kfm.getStart())) return false;
        return true;
    }

    protected String getExpectedType() {
        return KeepFromMessage.class.getName();
    }
}

