/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.exceptions.ExceptionSupplierFromMessage;
import io.hotmoka.exceptions.Objects;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.BeginBlockMessage;
import io.mokamint.application.messages.internal.json.BeginBlockMessageJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;

public class BeginBlockMessageImpl
extends AbstractRpcMessage
implements BeginBlockMessage {
    private final long height;
    private final byte[] stateId;
    private final LocalDateTime when;

    public BeginBlockMessageImpl(long height, LocalDateTime when, byte[] stateId, String id) {
        this(height, when, stateId, id, IllegalArgumentException::new);
    }

    public BeginBlockMessageImpl(BeginBlockMessageJson json) throws InconsistentJsonException {
        this(json.getHeight(), BeginBlockMessageImpl.parse((String)Objects.requireNonNull((Object)json.getWhen(), (String)"when cannot be null", InconsistentJsonException::new)), Hex.fromHexString((String)((String)Objects.requireNonNull((Object)json.getStateId(), (String)"stateId cannot be null", InconsistentJsonException::new)), InconsistentJsonException::new), json.getId(), InconsistentJsonException::new);
    }

    private static LocalDateTime parse(String when) throws InconsistentJsonException {
        try {
            return LocalDateTime.parse(when, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    private <E extends Exception> BeginBlockMessageImpl(long height, LocalDateTime when, byte[] stateId, String id, ExceptionSupplierFromMessage<? extends E> onIllegalArgs) throws E {
        super(id, onIllegalArgs);
        this.height = height;
        if (height < 0L) {
            throw (Exception)onIllegalArgs.apply((Object)"height must be non-negative");
        }
        this.stateId = (byte[])((byte[])Objects.requireNonNull((Object)stateId, (String)"stateId cannot be null", onIllegalArgs)).clone();
        this.when = (LocalDateTime)Objects.requireNonNull((Object)when, (String)"when cannot be null", onIllegalArgs);
    }

    public long getHeight() {
        return this.height;
    }

    public byte[] getStateId() {
        return (byte[])this.stateId.clone();
    }

    public LocalDateTime getWhen() {
        return this.when;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof BeginBlockMessage)) return false;
        BeginBlockMessage bbm = (BeginBlockMessage)other;
        if (!super.equals(other)) return false;
        if (this.height != bbm.getHeight()) return false;
        if (!this.when.equals(bbm.getWhen())) return false;
        if (!Arrays.equals(this.stateId, bbm.getStateId())) return false;
        return true;
    }

    protected String getExpectedType() {
        return BeginBlockMessage.class.getName();
    }
}

