/*
Copyright 2024 Fausto Spoto

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package io.mokamint.application.messages;

import io.hotmoka.websockets.beans.MappedDecoder;
import io.hotmoka.websockets.beans.MappedEncoder;
import io.mokamint.application.messages.api.CheckTransactionResultMessage;
import io.mokamint.application.messages.internal.CheckTransactionResultMessageImpl;
import io.mokamint.application.messages.internal.json.CheckTransactionResultMessageJson;

/**
 * A provider of {@link CheckTransactionResultMessage}.
 */
public abstract class CheckTransactionResultMessages {

	private CheckTransactionResultMessages() {}

	/**
	 * Yields a {@link CheckTransactionResultMessage}.
	 * 
	 * @param id the identifier of the message
	 * @return the message
	 */
	public static CheckTransactionResultMessage of(String id) {
		return new CheckTransactionResultMessageImpl(id);
	}

	/**
	 * Gson encoder.
	 */
	public static class Encoder extends MappedEncoder<CheckTransactionResultMessage, Json> {

		/**
		 * Creates a new encoder.
		 */
		public Encoder() {
			super(Json::new);
		}
	}

	/**
	 * Gson decoder.
	 */
	public static class Decoder extends MappedDecoder<CheckTransactionResultMessage, Json> {

		/**
		 * Creates a new decoder.
		 */
		public Decoder() {
			super(Json.class);
		}
	}

	/**
     * Json representation.
     */
    public static class Json extends CheckTransactionResultMessageJson {

    	/**
    	 * Creates the Json representation for the given message.
    	 * 
    	 * @param message the message
    	 */
    	public Json(CheckTransactionResultMessage message) {
    		super(message);
    	}
    }
}