/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.KeepFromMessage;
import io.mokamint.application.messages.internal.gson.KeepFromMessageJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class KeepFromMessageImpl
extends AbstractRpcMessage
implements KeepFromMessage {
    private final LocalDateTime start;

    public KeepFromMessageImpl(LocalDateTime start, String id) {
        super(id);
        this.start = start;
    }

    public KeepFromMessageImpl(KeepFromMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        String start = json.getStart();
        if (start == null) {
            throw new InconsistentJsonException("start cannot be nul");
        }
        try {
            this.start = LocalDateTime.parse(start, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof KeepFromMessage)) return false;
        KeepFromMessage kfm = (KeepFromMessage)other;
        if (!super.equals(other)) return false;
        if (!this.start.equals(kfm.getStart())) return false;
        return true;
    }

    protected String getExpectedType() {
        return KeepFromMessage.class.getName();
    }
}

