/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.EndBlockResultMessage;
import io.mokamint.application.messages.internal.gson.EndBlockResultMessageJson;
import java.util.Arrays;

public class EndBlockResultMessageImpl
extends AbstractRpcMessage
implements EndBlockResultMessage {
    private final byte[] result;

    public EndBlockResultMessageImpl(byte[] result, String id) {
        super(id);
        this.result = (byte[])result.clone();
    }

    public EndBlockResultMessageImpl(EndBlockResultMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        String result = json.getResult();
        if (result == null) {
            throw new InconsistentJsonException("result cannot be null");
        }
        try {
            this.result = Hex.fromHexString((String)result);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof EndBlockResultMessage)) return false;
        EndBlockResultMessage ebrm = (EndBlockResultMessage)other;
        if (!super.equals(other)) return false;
        if (!Arrays.equals(this.result, (byte[])ebrm.get())) return false;
        return true;
    }

    protected String getExpectedType() {
        return EndBlockResultMessage.class.getName();
    }

    public byte[] get() {
        return (byte[])this.result.clone();
    }
}

