/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Base64;
import io.hotmoka.crypto.Base64ConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.DeliverTransactionMessage;
import io.mokamint.application.messages.internal.gson.DeliverTransactionMessageJson;
import io.mokamint.node.Transactions;
import io.mokamint.node.api.Transaction;
import java.util.Objects;

public class DeliverTransactionMessageImpl
extends AbstractRpcMessage
implements DeliverTransactionMessage {
    private final Transaction transaction;
    private final int groupId;

    public DeliverTransactionMessageImpl(int groupId, Transaction transaction, String id) {
        super(id);
        this.transaction = Objects.requireNonNull(transaction, "transaction cannot be null");
        this.groupId = groupId;
    }

    public DeliverTransactionMessageImpl(DeliverTransactionMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        String transactionBase64 = json.getTransaction();
        if (transactionBase64 == null) {
            throw new InconsistentJsonException("transaction cannot be null");
        }
        try {
            this.transaction = Transactions.of((byte[])Base64.fromBase64String((String)transactionBase64));
        }
        catch (Base64ConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        this.groupId = json.getGroupId();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public int getGroupId() {
        return this.groupId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof DeliverTransactionMessage)) return false;
        DeliverTransactionMessage dtm = (DeliverTransactionMessage)other;
        if (!super.equals(other)) return false;
        if (!this.transaction.equals((Object)dtm.getTransaction())) return false;
        if (this.groupId != dtm.getGroupId()) return false;
        return true;
    }

    protected String getExpectedType() {
        return DeliverTransactionMessage.class.getName();
    }
}

