/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Base64;
import io.hotmoka.crypto.Base64ConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.CheckTransactionMessage;
import io.mokamint.application.messages.internal.gson.CheckTransactionMessageJson;
import io.mokamint.node.Transactions;
import io.mokamint.node.api.Transaction;
import java.util.Objects;

public class CheckTransactionMessageImpl
extends AbstractRpcMessage
implements CheckTransactionMessage {
    private final Transaction transaction;

    public CheckTransactionMessageImpl(Transaction transaction, String id) {
        super(id);
        this.transaction = Objects.requireNonNull(transaction, "transaction cannot be null");
    }

    public CheckTransactionMessageImpl(CheckTransactionMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        String transactionBase64 = json.getTransaction();
        if (transactionBase64 == null) {
            throw new InconsistentJsonException("transaction cannot be null");
        }
        try {
            this.transaction = Transactions.of((byte[])Base64.fromBase64String((String)transactionBase64));
        }
        catch (Base64ConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof CheckTransactionMessage)) return false;
        CheckTransactionMessage ctm = (CheckTransactionMessage)other;
        if (!super.equals(other)) return false;
        if (!this.transaction.equals((Object)ctm.getTransaction())) return false;
        return true;
    }

    protected String getExpectedType() {
        return CheckTransactionMessage.class.getName();
    }
}

