/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.CheckPrologExtraMessage;
import io.mokamint.application.messages.internal.gson.CheckPrologExtraMessageJson;
import java.util.Arrays;
import java.util.Objects;

public class CheckPrologExtraMessageImpl
extends AbstractRpcMessage
implements CheckPrologExtraMessage {
    private final byte[] extra;

    public CheckPrologExtraMessageImpl(byte[] extra, String id) {
        super(id);
        this.extra = Objects.requireNonNull(extra);
    }

    public CheckPrologExtraMessageImpl(CheckPrologExtraMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        String extra = json.getExtra();
        if (extra == null) {
            throw new InconsistentJsonException("extra cannot be null");
        }
        try {
            this.extra = Hex.fromHexString((String)extra);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public byte[] getExtra() {
        return (byte[])this.extra.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof CheckPrologExtraMessage)) return false;
        CheckPrologExtraMessage cpem = (CheckPrologExtraMessage)other;
        if (!super.equals(other)) return false;
        if (!Arrays.equals(this.extra, cpem.getExtra())) return false;
        return true;
    }

    protected String getExpectedType() {
        return CheckPrologExtraMessage.class.getName();
    }
}

