/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.GetInitialStateIdResultMessage;
import io.mokamint.application.messages.internal.gson.GetInitialStateIdResultMessageJson;
import java.util.Arrays;

public class GetInitialStateIdResultMessageImpl
extends AbstractRpcMessage
implements GetInitialStateIdResultMessage {
    private final byte[] result;

    public GetInitialStateIdResultMessageImpl(byte[] result, String id) {
        super(id);
        this.result = (byte[])result.clone();
    }

    public GetInitialStateIdResultMessageImpl(GetInitialStateIdResultMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        String result = json.getResult();
        if (result == null) {
            throw new InconsistentJsonException("result cannot be null");
        }
        try {
            this.result = Hex.fromHexString((String)result);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GetInitialStateIdResultMessage)) return false;
        GetInitialStateIdResultMessage gisirm = (GetInitialStateIdResultMessage)other;
        if (!super.equals(other)) return false;
        if (!Arrays.equals(this.result, (byte[])gisirm.get())) return false;
        return true;
    }

    protected String getExpectedType() {
        return GetInitialStateIdResultMessage.class.getName();
    }

    public byte[] get() {
        return (byte[])this.result.clone();
    }
}

