/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.EndBlockMessage;
import io.mokamint.application.messages.internal.gson.EndBlockMessageJson;
import io.mokamint.nonce.Deadlines;
import io.mokamint.nonce.api.Deadline;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class EndBlockMessageImpl
extends AbstractRpcMessage
implements EndBlockMessage {
    private final int groupId;
    private final Deadline deadline;

    public EndBlockMessageImpl(int groupId, Deadline deadline, String id) {
        super(id);
        this.groupId = groupId;
        this.deadline = Objects.requireNonNull(deadline, "deadline cannot be null");
    }

    public EndBlockMessageImpl(EndBlockMessageJson json) throws InconsistentJsonException, NoSuchAlgorithmException {
        super(json.getId());
        this.groupId = json.getGroupId();
        Deadlines.Json deadline = json.getDeadline();
        if (deadline == null) {
            throw new InconsistentJsonException("deadline cannot be null");
        }
        this.deadline = deadline.unmap();
    }

    public Deadline getDeadline() {
        return this.deadline;
    }

    public int getGroupId() {
        return this.groupId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof EndBlockMessage)) return false;
        EndBlockMessage ebm = (EndBlockMessage)other;
        if (!super.equals(other)) return false;
        if (this.groupId != ebm.getGroupId()) return false;
        if (!this.deadline.equals((Object)ebm.getDeadline())) return false;
        return true;
    }

    protected String getExpectedType() {
        return EndBlockMessage.class.getName();
    }
}

