/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessage;
import io.hotmoka.websockets.beans.api.InconsistentJsonException;
import io.mokamint.application.messages.api.BeginBlockMessage;
import io.mokamint.application.messages.internal.gson.BeginBlockMessageJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Objects;

public class BeginBlockMessageImpl
extends AbstractRpcMessage
implements BeginBlockMessage {
    private final long height;
    private final byte[] stateId;
    private final LocalDateTime when;

    public BeginBlockMessageImpl(long height, LocalDateTime when, byte[] stateId, String id) {
        super(id);
        this.height = height;
        if (height < 0L) {
            throw new IllegalArgumentException("height must be non-negative");
        }
        this.stateId = (byte[])stateId.clone();
        this.when = Objects.requireNonNull(when, "when cannot be null");
    }

    public BeginBlockMessageImpl(BeginBlockMessageJson json) throws InconsistentJsonException {
        super(json.getId());
        this.height = json.getHeight();
        String stateId = json.getStateId();
        if (stateId == null) {
            throw new InconsistentJsonException("stateId cannot be null");
        }
        String when = json.getWhen();
        if (when == null) {
            throw new InconsistentJsonException("when cannot be null");
        }
        try {
            this.stateId = Hex.fromHexString((String)stateId);
        }
        catch (HexConversionException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
        try {
            this.when = LocalDateTime.parse(when, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new InconsistentJsonException((Throwable)e);
        }
    }

    public long getHeight() {
        return this.height;
    }

    public byte[] getStateId() {
        return (byte[])this.stateId.clone();
    }

    public LocalDateTime getWhen() {
        return this.when;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof BeginBlockMessage)) return false;
        BeginBlockMessage bbm = (BeginBlockMessage)other;
        if (!super.equals(other)) return false;
        if (this.height != bbm.getHeight()) return false;
        if (!this.when.equals(bbm.getWhen())) return false;
        if (!Arrays.equals(this.stateId, bbm.getStateId())) return false;
        return true;
    }

    protected String getExpectedType() {
        return BeginBlockMessage.class.getName();
    }
}

