/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.messages.internal.gson;

import io.hotmoka.crypto.Hex;
import io.hotmoka.crypto.HexConversionException;
import io.hotmoka.websockets.beans.AbstractRpcMessageJsonRepresentation;
import io.hotmoka.websockets.beans.api.RpcMessage;
import io.mokamint.application.messages.BeginBlockMessages;
import io.mokamint.application.messages.api.BeginBlockMessage;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class BeginBlockMessageJson
extends AbstractRpcMessageJsonRepresentation<BeginBlockMessage> {
    private final long height;
    private final String stateId;
    private final String when;

    protected BeginBlockMessageJson(BeginBlockMessage message) {
        super((RpcMessage)message);
        this.height = message.getHeight();
        this.stateId = Hex.toHexString((byte[])message.getStateId());
        this.when = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(message.getWhen());
    }

    public BeginBlockMessage unmap() throws HexConversionException {
        return BeginBlockMessages.of(this.height, LocalDateTime.parse(this.when, DateTimeFormatter.ISO_LOCAL_DATE_TIME), Hex.fromHexString((String)this.stateId), this.getId());
    }

    protected String getExpectedType() {
        return BeginBlockMessage.class.getName();
    }
}

